/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.editors;

import java.net.URI;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipsetrader.core.ats.ScriptStrategy;
import org.eclipsetrader.core.repositories.IRepositoryChangeListener;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.RepositoryChangeEvent;
import org.eclipsetrader.core.repositories.RepositoryResourceDelta;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.editors.BaseJavaScriptEditor;
import org.eclipsetrader.ui.internal.editors.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ScriptStrategyEditor
extends BaseJavaScriptEditor {
    public static final String VIEW_ID = "org.eclipsetrader.ui.ats.scritpstrategy.editor";
    private URI uri;
    private ScriptStrategy script;
    IDialogSettings dialogSettings;
    IRepositoryService repositoryService;
    private final IRepositoryChangeListener changeListener = new IRepositoryChangeListener(){

        public void repositoryResourceChanged(RepositoryChangeEvent event) {
            RepositoryResourceDelta[] repositoryResourceDeltaArray = event.getDeltas();
            int n = repositoryResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryResourceDelta delta = repositoryResourceDeltaArray[n2];
                if (delta.getResource() == ScriptStrategyEditor.this.script) {
                    if ((delta.getKind() & 2) != 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbench workbench = PlatformUI.getWorkbench();
                                workbench.getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)ScriptStrategyEditor.this);
                            }
                        });
                    } else if ((delta.getKind() & 0x2000) != 0) {
                        ScriptStrategyEditor.this.dialogSettings.put("uri", ScriptStrategyEditor.this.script.getStore().toURI().toString());
                    }
                }
                ++n2;
            }
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IRepositoryService.class);
        this.repositoryService = (IRepositoryService)bundleContext.getService(serviceReference);
        this.dialogSettings = UIActivator.getDefault().getDialogSettings().getSection("Views").getSection(site.getSecondaryId());
        try {
            this.uri = new URI(this.dialogSettings.get("uri"));
            this.script = (ScriptStrategy)this.repositoryService.getObjectFromURI(this.uri);
        }
        catch (Exception e) {
            throw new PartInitException("Error loading view " + site.getSecondaryId(), (Throwable)e);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.script != null) {
            this.setPartName(this.script.getName());
            if (this.script.getText() != null) {
                this.setText(this.script.getText());
            }
        }
        this.repositoryService.addRepositoryResourceListener(this.changeListener);
    }

    public void doSave(IProgressMonitor monitor) {
        this.script.setText(this.getText());
        IStatus status = this.repositoryService.runInService(new IRepositoryRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                ScriptStrategyEditor.this.repositoryService.saveAdaptable(new IAdaptable[]{ScriptStrategyEditor.this.script});
                return Status.OK_STATUS;
            }
        }, monitor);
        if (status == Status.OK_STATUS) {
            this.setDirty(false);
        }
    }

    public void doSaveAs() {
        String newName = String.valueOf(Messages.ScriptStrategyEditor_CopyOf) + this.script.getName();
        InputDialog dlg = new InputDialog(this.getSite().getShell(), Messages.ScriptStrategyEditor_SaveAs, Messages.ScriptStrategyEditor_NewName, newName, null);
        if (dlg.open() == 0) {
            final ScriptStrategy newScript = new ScriptStrategy(dlg.getValue());
            newScript.setLanguage(this.script.getLanguage());
            newScript.setText(this.getText());
            IStatus status = this.repositoryService.runInService(new IRepositoryRunnable(){

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    ScriptStrategyEditor.this.repositoryService.saveAdaptable(new IAdaptable[]{newScript});
                    return Status.OK_STATUS;
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            if (status == Status.OK_STATUS) {
                this.script = newScript;
                this.uri = this.script.getStore().toURI();
                this.dialogSettings.put("uri", this.uri.toString());
                this.setPartName(this.script.getName());
                this.setDirty(false);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    @Override
    public void dispose() {
        BundleContext bundleContext = UIActivator.getDefault().getBundle().getBundleContext();
        this.repositoryService.removeRepositoryResourceListener(this.changeListener);
        ServiceReference serviceReference = bundleContext.getServiceReference(IRepositoryService.class);
        if (serviceReference != null && this.repositoryService != null) {
            bundleContext.ungetService(serviceReference);
        }
        super.dispose();
    }
}

