/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.markets.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConnectorsWizardPage
extends WizardPage {
    ComboViewer liveFeed;
    private List<Object> connectors = new ArrayList<Object>();

    public ConnectorsWizardPage() {
        super("connectors", Messages.ConnectorsWizardPage_Connectors, null);
        this.setDescription(Messages.ConnectorsWizardPage_SelectConnectors);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)content);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(content, 0);
        label.setText(Messages.ConnectorsWizardPage_LiveFeed);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        this.liveFeed = new ComboViewer(content, 8);
        this.liveFeed.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.liveFeed.getCombo().setVisibleItemCount(15);
        this.liveFeed.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IFeedConnector)) {
                    IFeedConnector defaultConnector = CoreActivator.getDefault().getDefaultConnector();
                    return NLS.bind((String)Messages.ConnectorsWizardPage_Default, (Object[])new Object[]{defaultConnector != null ? defaultConnector.getName() : Messages.ConnectorsWizardPage_None});
                }
                return ((IFeedConnector)element).getName();
            }
        });
        this.liveFeed.setSorter(new ViewerSorter());
        this.liveFeed.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.connectors.add(new Object());
        this.connectors.addAll(Arrays.asList(this.getFeedService().getConnectors()));
        this.liveFeed.setInput((Object)this.connectors.toArray());
        this.liveFeed.setSelection((ISelection)new StructuredSelection(this.connectors.get(0)));
        this.liveFeed.getControl().setFocus();
    }

    public boolean isPageComplete() {
        return true;
    }

    public IFeedConnector getLiveFeedConnector() {
        Object s = ((IStructuredSelection)this.liveFeed.getSelection()).getFirstElement();
        return s instanceof IFeedConnector ? (IFeedConnector)s : null;
    }

    protected IFeedService getFeedService() {
        try {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IFeedService.class.getName());
            IFeedService service = (IFeedService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, Messages.ConnectorsWizardPage_ErrorReadingFeedService, (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }
}

