/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.jface.cdatetime.CDateTimeCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipsetrader.core.internal.markets.MarketTimeExclude;
import org.eclipsetrader.ui.internal.markets.MarketTimeElement;
import org.eclipsetrader.ui.internal.markets.Messages;

public class ExclusionScheduleEditor {
    private Composite content;
    private TableViewer viewer;
    private Button add;
    private Button remove;
    private List<MarketTimeElement.MarketTimeExcludeElement> input = new ArrayList<MarketTimeElement.MarketTimeExcludeElement>();

    protected ExclusionScheduleEditor() {
    }

    public ExclusionScheduleEditor(Composite parent) {
        this.content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.content.setLayout((Layout)gridLayout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createViewer(this.content);
        this.createButtons(this.content);
    }

    protected void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 67586);
        this.viewer.getTable().setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = this.viewer.getTable().getItemHeight() * 5 + this.viewer.getTable().getBorderWidth() * 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.ExclusionScheduleEditor_From);
        tableColumn.setWidth(70);
        tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.ExclusionScheduleEditor_To);
        tableColumn.setWidth(70);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScheduleElementLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((MarketTimeElement.MarketTimeExcludeElement)e1).compareTo((MarketTimeElement.MarketTimeExcludeElement)e2);
            }
        });
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                MarketTimeElement.MarketTimeExcludeElement e = (MarketTimeElement.MarketTimeExcludeElement)element;
                int columnIndex = Integer.valueOf(property);
                switch (columnIndex) {
                    case 0: {
                        return e.getFromDate();
                    }
                    case 1: {
                        return e.getToDate();
                    }
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                MarketTimeElement.MarketTimeExcludeElement e = (MarketTimeElement.MarketTimeExcludeElement)(element instanceof TableItem ? ((TableItem)element).getData() : element);
                int columnIndex = Integer.valueOf(property);
                switch (columnIndex) {
                    case 0: {
                        e.setFromDate(this.normalizeDate((Date)value));
                        break;
                    }
                    case 1: {
                        e.setToDate(this.normalizeDate((Date)value));
                    }
                }
                ExclusionScheduleEditor.this.viewer.refresh();
            }

            private Date normalizeDate(Date date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar.getTime();
            }
        });
        this.viewer.setColumnProperties(new String[]{"0", "1"});
        this.viewer.setCellEditors(new CellEditor[]{new CDateTimeCellEditor((Composite)this.viewer.getTable(), 0x100000), new CDateTimeCellEditor((Composite)this.viewer.getTable(), 0x100000)});
        this.viewer.setInput(this.input);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ExclusionScheduleEditor.this.remove != null) {
                    ExclusionScheduleEditor.this.remove.setEnabled(!event.getSelection().isEmpty());
                }
            }
        });
    }

    protected void createButtons(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 128, false, false));
        this.add = new Button(content, 8);
        this.add.setText(Messages.ExclusionScheduleEditor_Add);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                MarketTimeElement.MarketTimeExcludeElement element = new MarketTimeElement.MarketTimeExcludeElement(calendar.getTime(), calendar.getTime());
                ExclusionScheduleEditor.this.input.add(element);
                ExclusionScheduleEditor.this.viewer.refresh();
                ExclusionScheduleEditor.this.viewer.getControl().setFocus();
                ExclusionScheduleEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
                ExclusionScheduleEditor.this.viewer.editElement((Object)element, 0);
            }
        });
        this.add.setLayoutData((Object)new GridData(4, 128, false, false));
        this.remove = new Button(content, 8);
        this.remove.setText(Messages.ExclusionScheduleEditor_Remove);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ExclusionScheduleEditor.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    ExclusionScheduleEditor.this.input.removeAll(selection.toList());
                    ExclusionScheduleEditor.this.viewer.refresh();
                }
            }
        });
        this.remove.setLayoutData((Object)new GridData(4, 128, false, false));
        this.remove.setEnabled(false);
    }

    public void setSchedule(MarketTimeExclude[] schedule) {
        this.input.clear();
        MarketTimeExclude[] marketTimeExcludeArray = schedule;
        int n = schedule.length;
        int n2 = 0;
        while (n2 < n) {
            MarketTimeExclude time = marketTimeExcludeArray[n2];
            this.input.add(new MarketTimeElement.MarketTimeExcludeElement(time));
            ++n2;
        }
        this.viewer.refresh();
    }

    public MarketTimeExclude[] getSchedule() {
        MarketTimeExclude[] result = new MarketTimeExclude[this.input.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.input.get(i).getMarketTimeExclude();
            ++i;
        }
        return result;
    }

    public Control getControl() {
        return this.content;
    }

    protected TableViewer getViewer() {
        return this.viewer;
    }

    protected List<MarketTimeElement.MarketTimeExcludeElement> getInput() {
        return this.input;
    }

    public void setInput(List<MarketTimeElement.MarketTimeExcludeElement> input) {
        this.input = input;
        this.viewer.setInput(this.input);
    }

    private class ScheduleElementLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DateFormat dateFormat = DateFormat.getDateInstance(3);

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MarketTimeElement.MarketTimeExcludeElement) {
                MarketTimeElement.MarketTimeExcludeElement e = (MarketTimeElement.MarketTimeExcludeElement)element;
                switch (columnIndex) {
                    case 0: {
                        return this.dateFormat.format(e.getFromDate());
                    }
                    case 1: {
                        return this.dateFormat.format(e.getToDate());
                    }
                }
            }
            return "";
        }
    }
}

