/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.TimeZone;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.internal.markets.Market;
import org.eclipsetrader.ui.internal.markets.ExclusionScheduleEditor;
import org.eclipsetrader.ui.internal.markets.MarketTimeElement;
import org.eclipsetrader.ui.internal.markets.Messages;
import org.eclipsetrader.ui.internal.markets.TimeScheduleEditor;

public class GeneralPage
extends PropertyPage {
    private TimeScheduleEditor schedule;
    private ExclusionScheduleEditor excluded;
    private Button sun;
    private Button mon;
    private Button tue;
    private Button wed;
    private Button thu;
    private Button fri;
    private Button sat;
    private ComboViewer timeZone;

    public GeneralPage() {
        this.setTitle(Messages.GeneralPage_General);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Market market;
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.GeneralPage_Schedule);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        ((GridData)label.getLayoutData()).horizontalSpan = 2;
        this.schedule = new TimeScheduleEditor(content);
        ((GridData)this.schedule.getControl().getLayoutData()).horizontalSpan = 2;
        this.schedule.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    MarketTimeElement element = (MarketTimeElement)selection.getFirstElement();
                    GeneralPage.this.excluded.setInput(element.getExclude());
                }
            }
        });
        label = new Label(content, 0);
        label.setText(Messages.GeneralPage_ExcludedDays);
        label.setLayoutData((Object)new GridData(this.convertHorizontalDLUsToPixels(80), -1));
        ((GridData)label.getLayoutData()).horizontalSpan = 2;
        this.excluded = new ExclusionScheduleEditor(content);
        ((GridData)this.excluded.getControl().getLayoutData()).horizontalSpan = 2;
        label = new Label(content, 0);
        label.setText(Messages.GeneralPage_WeekDays);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        ((GridData)label.getLayoutData()).verticalIndent = this.convertHorizontalDLUsToPixels(3);
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout(5, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1, 128, false, false));
        this.mon = new Button(group, 32);
        this.mon.setText(Messages.GeneralPage_Mon);
        this.tue = new Button(group, 32);
        this.tue.setText(Messages.GeneralPage_Tue);
        this.wed = new Button(group, 32);
        this.wed.setText(Messages.GeneralPage_Wed);
        this.thu = new Button(group, 32);
        this.thu.setText(Messages.GeneralPage_Thu);
        this.fri = new Button(group, 32);
        this.fri.setText(Messages.GeneralPage_Fri);
        this.sun = new Button(group, 32);
        this.sun.setText(Messages.GeneralPage_Sun);
        this.sat = new Button(group, 32);
        this.sat.setText(Messages.GeneralPage_Sat);
        label = new Label(content, 0);
        label.setText(Messages.GeneralPage_TimeZone);
        this.timeZone = new ComboViewer(content, 8);
        this.timeZone.getCombo().setVisibleItemCount(15);
        this.timeZone.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.timeZone.setSorter(new ViewerSorter());
        this.timeZone.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.timeZone.setInput((Object)TimeZone.getAvailableIDs());
        if (this.getElement() != null && (market = (Market)this.getElement().getAdapter(Market.class)) != null) {
            this.schedule.setSchedule(market.getSchedule());
            HashSet<Integer> weekdays = new HashSet<Integer>(Arrays.asList(market.getWeekDays()));
            this.sun.setSelection(weekdays.contains(1));
            this.mon.setSelection(weekdays.contains(2));
            this.tue.setSelection(weekdays.contains(3));
            this.wed.setSelection(weekdays.contains(4));
            this.thu.setSelection(weekdays.contains(5));
            this.fri.setSelection(weekdays.contains(6));
            this.sat.setSelection(weekdays.contains(7));
            if (market.getTimeZone() != null) {
                this.timeZone.setSelection((ISelection)new StructuredSelection((Object)market.getTimeZone().getID()));
            }
        }
        return content;
    }

    public boolean isValid() {
        return this.sun.getSelection() || this.mon.getSelection() || this.tue.getSelection() || this.wed.getSelection() || this.thu.getSelection() || this.fri.getSelection() || this.sat.getSelection();
    }

    public boolean performOk() {
        Market market;
        if (this.isControlCreated() && this.getElement() != null && (market = (Market)this.getElement().getAdapter(Market.class)) != null) {
            market.setSchedule(this.schedule.getSchedule());
            HashSet<Integer> weekdays = new HashSet<Integer>();
            if (this.sun.getSelection()) {
                weekdays.add(1);
            }
            if (this.mon.getSelection()) {
                weekdays.add(2);
            }
            if (this.tue.getSelection()) {
                weekdays.add(3);
            }
            if (this.wed.getSelection()) {
                weekdays.add(4);
            }
            if (this.thu.getSelection()) {
                weekdays.add(5);
            }
            if (this.fri.getSelection()) {
                weekdays.add(6);
            }
            if (this.sat.getSelection()) {
                weekdays.add(7);
            }
            market.setWeekDays(weekdays.toArray(new Integer[weekdays.size()]));
            IStructuredSelection selection = (IStructuredSelection)this.timeZone.getSelection();
            market.setTimeZone(selection.isEmpty() ? null : TimeZone.getTimeZone((String)selection.getFirstElement()));
        }
        return super.performOk();
    }
}

