/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.text.DateFormat;
import java.util.Calendar;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketDay;
import org.eclipsetrader.ui.internal.markets.Messages;

public class MarketLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private Image marketImage;
    private Color closedColor = Display.getDefault().getSystemColor(18);

    public MarketLabelProvider() {
    }

    public MarketLabelProvider(Image marketImage) {
        this.marketImage = marketImage;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof IMarket) {
            return this.marketImage;
        }
        return null;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IMarket) {
            IMarket market = (IMarket)element;
            switch (columnIndex) {
                case 0: {
                    return market.getName();
                }
                case 1: {
                    IMarketDay day = market.getToday();
                    if (day.isOpen()) {
                        return day.getMessage() != null ? day.getMessage() : Messages.MarketLabelProvider_Open;
                    }
                    if (day.getMessage() != null) {
                        return NLS.bind((String)Messages.MarketLabelProvider_ClosedFor, (Object[])new Object[]{day.getMessage()});
                    }
                    return Messages.MarketLabelProvider_Closed;
                }
                case 2: {
                    Calendar now = Calendar.getInstance();
                    IMarketDay day = market.getToday();
                    if (day.isOpen()) {
                        long secondsToClose = (day.getCloseTime().getTime() - now.getTimeInMillis()) / 1000L;
                        if (secondsToClose < 60L) {
                            return Messages.MarketLabelProvider_ClosesInLessThanOneMinute;
                        }
                        long minutesToClose = secondsToClose / 60L + 1L;
                        if (minutesToClose < 60L) {
                            return NLS.bind((String)Messages.MarketLabelProvider_ClosesInMinutes, (Object[])new Object[]{minutesToClose});
                        }
                        return NLS.bind((String)Messages.MarketLabelProvider_ClosesInHours, (Object[])new Object[]{minutesToClose / 60L, minutesToClose % 60L});
                    }
                    Calendar midnight = Calendar.getInstance();
                    midnight.set(11, 0);
                    midnight.set(12, 0);
                    midnight.set(13, 0);
                    midnight.set(14, 0);
                    midnight.add(5, 1);
                    day = market.getNextDay();
                    if (day == null || day.getOpenTime() == null) break;
                    long secondsToNextOpen = (day.getOpenTime().getTime() - now.getTimeInMillis()) / 1000L;
                    if (secondsToNextOpen < 60L) {
                        return Messages.MarketLabelProvider_OpenInLessThanOneMinute;
                    }
                    long minutesToNextOpen = secondsToNextOpen / 60L + 1L;
                    if (minutesToNextOpen < 60L) {
                        return NLS.bind((String)Messages.MarketLabelProvider_OpensInMinutes, (Object[])new Object[]{minutesToNextOpen});
                    }
                    if (day.getOpenTime().before(midnight.getTime()) && minutesToNextOpen < 1440L) {
                        return NLS.bind((String)Messages.MarketLabelProvider_OpensInHours, (Object[])new Object[]{minutesToNextOpen / 60L, minutesToNextOpen % 60L});
                    }
                    DateFormat dateFormat = DateFormat.getDateInstance(1);
                    DateFormat timeFormat = DateFormat.getTimeInstance(3);
                    return NLS.bind((String)Messages.MarketLabelProvider_OpenDate, (Object[])new Object[]{dateFormat.format(day.getOpenTime()), timeFormat.format(day.getOpenTime())});
                }
            }
        }
        return "";
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IMarket && !((IMarket)element).isOpen()) {
            return this.closedColor;
        }
        return null;
    }
}

