/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.util.Arrays;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipsetrader.core.internal.markets.Market;
import org.eclipsetrader.core.internal.markets.MarketService;
import org.eclipsetrader.ui.internal.markets.ConnectorsWizardPage;
import org.eclipsetrader.ui.internal.markets.GeneralWizardPage;
import org.eclipsetrader.ui.internal.markets.Messages;
import org.eclipsetrader.ui.internal.markets.ScheduleWizardPage;

public class MarketWizard
extends Wizard {
    GeneralWizardPage generalPage;
    ScheduleWizardPage schedulePage;
    ConnectorsWizardPage connectorsPage;
    MarketService marketService;
    Market market;

    protected MarketWizard() {
    }

    public MarketWizard(MarketService marketService) {
        this.marketService = marketService;
    }

    public void addPages() {
        this.setWindowTitle(Messages.MarketWizard_NewMarket);
        this.generalPage = new GeneralWizardPage(this.marketService);
        this.addPage((IWizardPage)this.generalPage);
        this.schedulePage = new ScheduleWizardPage();
        this.addPage((IWizardPage)this.schedulePage);
        this.connectorsPage = new ConnectorsWizardPage();
        this.addPage((IWizardPage)this.connectorsPage);
    }

    public boolean performFinish() {
        this.market = new Market(this.generalPage.getMarketName(), Arrays.asList(this.schedulePage.getSchedule()), this.schedulePage.getTimeZone());
        this.market.setWeekDays(this.schedulePage.getWeekDays());
        this.market.setLiveFeedConnector(this.connectorsPage.getLiveFeedConnector());
        return true;
    }

    public MarketService getMarketService() {
        return this.marketService;
    }

    public Market getMarket() {
        return this.market;
    }
}

