/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.internal.markets.Market;
import org.eclipsetrader.core.internal.markets.MarketService;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketStatusListener;
import org.eclipsetrader.core.markets.MarketStatusEvent;
import org.eclipsetrader.ui.SelectionProvider;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.markets.MarketLabelProvider;
import org.eclipsetrader.ui.internal.markets.Messages;
import org.eclipsetrader.ui.internal.markets.NewMarketAction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarketsView
extends ViewPart {
    Display display;
    TableViewer viewer;
    private Image marketIcon;
    Action newMarketAction;
    Action deleteAction;
    MarketService marketService;
    private Runnable timedRunnable = new Runnable(){

        @Override
        public void run() {
            if (!MarketsView.this.viewer.getControl().isDisposed()) {
                MarketsView.this.viewer.update((Object[])MarketsView.this.viewer.getInput(), null);
                int delay = (int)(60000L - System.currentTimeMillis() % 60000L);
                Display.getCurrent().timerExec(delay, MarketsView.this.timedRunnable);
            }
        }
    };
    private Observer serviceObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            MarketsView.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!(this).MarketsView.this.viewer.getControl().isDisposed()) {
                        MarketsView.this.refreshInput();
                    }
                }
            });
        }
    };
    private IMarketStatusListener marketStatusListener = new IMarketStatusListener(){

        public void marketStatusChanged(MarketStatusEvent event) {
            final IMarket market = event.getMarket();
            MarketsView.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!(this).MarketsView.this.viewer.getControl().isDisposed()) {
                        (this).MarketsView.this.viewer.update((Object)market, null);
                    }
                }
            });
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            MarketsView.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!(this).MarketsView.this.viewer.getControl().isDisposed()) {
                        if ("name".equals(evt.getPropertyName())) {
                            (this).MarketsView.this.viewer.refresh();
                        } else {
                            (this).MarketsView.this.viewer.update(evt.getSource(), null);
                        }
                    }
                }
            });
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(MarketService.class.getName());
        this.marketService = (MarketService)context.getService(serviceReference);
        context.ungetService(serviceReference);
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
        this.marketIcon = UIActivator.getDefault().getImageRegistry().get("market_obj");
        this.newMarketAction = new NewMarketAction(site.getShell());
        this.deleteAction = new Action(Messages.MarketsView_Delete){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)MarketsView.this.viewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Market) {
                        Market market = (Market)obj;
                        MarketsView.this.marketService.deleteMarket(market);
                        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)market.getAdapter(PropertyChangeSupport.class);
                        if (propertyChangeSupport != null) {
                            propertyChangeSupport.removePropertyChangeListener(MarketsView.this.propertyChangeListener);
                        }
                    }
                    ++n2;
                }
            }
        };
        this.deleteAction.setImageDescriptor(UIActivator.getDefault().getImageRegistry().getDescriptor("delete"));
        this.deleteAction.setDisabledImageDescriptor(UIActivator.getDefault().getImageRegistry().getDescriptor("delete_disabled"));
        this.deleteAction.setEnabled(false);
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.createViewer(parent);
        this.createContextMenu();
        this.refreshInput();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MarketsView.this.getViewSite().getSelectionProvider().setSelection(event.getSelection());
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                MarketsView.this.deleteAction.setEnabled(!selection.isEmpty());
            }
        });
        this.marketService.addMarketStatusListener(this.marketStatusListener);
        this.marketService.addObserver(this.serviceObserver);
        int delay = (int)(60000L - System.currentTimeMillis() % 60000L);
        Display.getCurrent().timerExec(delay, this.timedRunnable);
    }

    protected void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 65538);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(false);
        TableColumn tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.MarketsView_Market);
        tableColumn.setWidth(150);
        tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.MarketsView_State);
        tableColumn.setWidth(150);
        tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.MarketsView_Message);
        tableColumn.setWidth(250);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MarketLabelProvider(this.marketIcon));
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    protected void refreshInput() {
        IMarket[] input;
        IMarket[] iMarketArray = input = this.marketService.getMarkets();
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            IMarket market = iMarketArray[n2];
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)market.getAdapter(PropertyChangeSupport.class);
            if (propertyChangeSupport != null) {
                propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
                propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
            }
            ++n2;
        }
        this.viewer.setInput((Object)input);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        Display.getCurrent().timerExec(-1, this.timedRunnable);
        this.marketService.deleteObserver(this.serviceObserver);
        this.marketService.removeMarketStatusListener(this.marketStatusListener);
        super.dispose();
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                MenuManager newMenu = new MenuManager(Messages.MarketsView_New, "group.new");
                newMenu.add((IContributionItem)new Separator("top"));
                newMenu.add((IAction)MarketsView.this.newMarketAction);
                newMenu.add((IContributionItem)new Separator("additions"));
                newMenu.add((IContributionItem)new Separator("bottom"));
                menuManager.add((IContributionItem)newMenu);
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
                menuManager.appendToGroup("group.reorganize", (IAction)MarketsView.this.deleteAction);
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }
}

