/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.markets.Market;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.markets.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MembersPage
extends PropertyPage {
    private Button showMembers;
    private Button showUnlisted;
    private CheckboxTableViewer members;

    public MembersPage() {
        this.setTitle(Messages.MembersPage_Members);
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Market market;
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.showMembers = new Button(content, 16);
        this.showMembers.setText(Messages.MembersPage_ShowMembersOnly);
        this.showMembers.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.showMembers.setSelection(true);
        this.showMembers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MembersPage.this.refreshSelection();
            }
        });
        this.showUnlisted = new Button(content, 16);
        this.showUnlisted.setText(Messages.MembersPage_ShowSecurities);
        this.showUnlisted.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.showUnlisted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MembersPage.this.refreshSelection();
            }
        });
        this.members = CheckboxTableViewer.newCheckList((Composite)content, (int)2820);
        this.members.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)this.members.getControl().getLayoutData()).heightHint = this.members.getTable().getItemHeight() * 15 + this.members.getTable().getBorderWidth() * 2;
        ((GridData)this.members.getControl().getLayoutData()).verticalIndent = 5;
        this.members.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ISecurity)element).getName();
            }
        });
        this.members.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.members.setSorter(new ViewerSorter());
        this.members.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (MembersPage.this.showMembers.getSelection()) {
                    Market market = (Market)MembersPage.this.getElement().getAdapter(Market.class);
                    return market.hasMember((ISecurity)element);
                }
                IMarket[] iMarketArray = MembersPage.this.getMarkets();
                int n = iMarketArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarket market = iMarketArray[n2];
                    if (market != MembersPage.this.getElement() && market.hasMember((ISecurity)element)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        });
        this.members.setInput((Object)UIActivator.getDefault().getRepositoryService().getSecurities());
        if (this.getElement() != null && (market = (Market)this.getElement().getAdapter(Market.class)) != null) {
            this.members.setCheckedElements((Object[])market.getMembers());
        }
        return content;
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        Market market;
        if (this.isControlCreated() && this.getElement() != null && (market = (Market)this.getElement().getAdapter(Market.class)) != null) {
            Object[] checked = this.members.getCheckedElements();
            ISecurity[] securities = new ISecurity[checked.length];
            System.arraycopy(checked, 0, securities, 0, checked.length);
            market.removeMembers(market.getMembers());
            market.addMembers(securities);
        }
        return super.performOk();
    }

    protected IMarket[] getMarkets() {
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMarketService.class.getName());
        if (serviceReference != null) {
            IMarketService marketService = (IMarketService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return marketService.getMarkets();
        }
        return new IMarket[0];
    }

    protected void refreshSelection() {
        Market market;
        this.members.refresh();
        if (this.getElement() != null && (market = (Market)this.getElement().getAdapter(Market.class)) != null) {
            this.members.setCheckedElements((Object[])market.getMembers());
        }
    }
}

