/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.markets;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.jface.cdatetime.CDateTimeCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipsetrader.core.internal.markets.MarketTime;
import org.eclipsetrader.ui.internal.markets.MarketTimeElement;
import org.eclipsetrader.ui.internal.markets.Messages;

public class TimeScheduleEditor
extends Observable {
    private Composite content;
    private TableViewer viewer;
    private Button add;
    private Button remove;
    private List<MarketTimeElement> input = new ArrayList<MarketTimeElement>();

    protected TimeScheduleEditor() {
    }

    public TimeScheduleEditor(Composite parent) {
        this.content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.content.setLayout((Layout)gridLayout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createViewer(this.content);
        this.createButtons(this.content);
    }

    protected void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 67586);
        this.viewer.getTable().setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.viewer.getTable().getItemHeight() * 5 + this.viewer.getTable().getBorderWidth() * 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.TimeScheduleEditor_Open);
        tableColumn.setWidth(70);
        tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.TimeScheduleEditor_Close);
        tableColumn.setWidth(70);
        tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.TimeScheduleEditor_Description);
        tableColumn.setWidth(150);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScheduleElementLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((MarketTimeElement)e1).compareTo((MarketTimeElement)e2);
            }
        });
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                MarketTimeElement e = (MarketTimeElement)element;
                int columnIndex = Integer.valueOf(property);
                switch (columnIndex) {
                    case 0: {
                        return e.getOpenTime();
                    }
                    case 1: {
                        return e.getCloseTime();
                    }
                    case 2: {
                        return e.getDescription() != null ? e.getDescription() : "";
                    }
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                MarketTimeElement e = (MarketTimeElement)(element instanceof TableItem ? ((TableItem)element).getData() : element);
                int columnIndex = Integer.valueOf(property);
                switch (columnIndex) {
                    case 0: {
                        e.setOpenTime(this.normalizeDate((Date)value));
                        break;
                    }
                    case 1: {
                        e.setCloseTime(this.normalizeDate((Date)value));
                        break;
                    }
                    case 2: {
                        e.setDescription("".equals(value) ? null : value.toString());
                    }
                }
                TimeScheduleEditor.this.viewer.refresh();
                TimeScheduleEditor.this.setChanged();
                TimeScheduleEditor.this.notifyObservers();
            }

            private Date normalizeDate(Date date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar.getTime();
            }
        });
        this.viewer.setColumnProperties(new String[]{"0", "1", "2"});
        this.viewer.setCellEditors(new CellEditor[]{new CDateTimeCellEditor((Composite)this.viewer.getTable(), 0x800000), new CDateTimeCellEditor((Composite)this.viewer.getTable(), 0x800000), new TextCellEditor((Composite)this.viewer.getTable(), 0)});
        this.viewer.setInput(this.input);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TimeScheduleEditor.this.remove != null) {
                    TimeScheduleEditor.this.remove.setEnabled(!event.getSelection().isEmpty());
                }
            }
        });
    }

    protected void createButtons(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 128, false, false));
        this.add = new Button(content, 8);
        this.add.setText(Messages.TimeScheduleEditor_Add);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Calendar now = Calendar.getInstance();
                now.set(13, 0);
                now.set(14, 0);
                MarketTimeElement element = new MarketTimeElement(now.getTime(), now.getTime());
                TimeScheduleEditor.this.input.add(element);
                TimeScheduleEditor.this.viewer.refresh();
                TimeScheduleEditor.this.setChanged();
                TimeScheduleEditor.this.notifyObservers();
                TimeScheduleEditor.this.viewer.getControl().setFocus();
                TimeScheduleEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
                TimeScheduleEditor.this.viewer.editElement((Object)element, 0);
            }
        });
        this.add.setLayoutData((Object)new GridData(4, 128, false, false));
        this.remove = new Button(content, 8);
        this.remove.setText(Messages.TimeScheduleEditor_Remove);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TimeScheduleEditor.this.viewer.getSelection();
                if (!selection.isEmpty()) {
                    TimeScheduleEditor.this.input.removeAll(selection.toList());
                    TimeScheduleEditor.this.viewer.refresh();
                    TimeScheduleEditor.this.setChanged();
                    TimeScheduleEditor.this.notifyObservers();
                }
            }
        });
        this.remove.setLayoutData((Object)new GridData(4, 128, false, false));
        this.remove.setEnabled(false);
    }

    public void setSchedule(MarketTime[] schedule) {
        this.input.clear();
        MarketTime[] marketTimeArray = schedule;
        int n = schedule.length;
        int n2 = 0;
        while (n2 < n) {
            MarketTime time = marketTimeArray[n2];
            this.input.add(new MarketTimeElement(time));
            ++n2;
        }
        this.viewer.refresh();
    }

    public MarketTime[] getSchedule() {
        MarketTime[] result = new MarketTime[this.input.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.input.get(i).getMarketTime();
            ++i;
        }
        return result;
    }

    public Control getControl() {
        return this.content;
    }

    protected TableViewer getViewer() {
        return this.viewer;
    }

    protected List<MarketTimeElement> getInput() {
        return this.input;
    }

    protected void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    protected void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    private class ScheduleElementLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DateFormat timeFormat = DateFormat.getTimeInstance(3);

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MarketTimeElement) {
                MarketTimeElement e = (MarketTimeElement)element;
                switch (columnIndex) {
                    case 0: {
                        return this.timeFormat.format(e.getOpenTime());
                    }
                    case 1: {
                        return this.timeFormat.format(e.getCloseTime());
                    }
                    case 2: {
                        return e.getDescription() != null ? e.getDescription() : "";
                    }
                }
            }
            return "";
        }
    }
}

