/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.views.IView;
import org.eclipsetrader.core.views.IViewChangeListener;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.core.views.IViewVisitor;
import org.eclipsetrader.core.views.ViewEvent;
import org.eclipsetrader.core.views.ViewItemDelta;
import org.eclipsetrader.ui.internal.navigator.NavigatorViewItem;
import org.eclipsetrader.ui.navigator.INavigatorContentGroup;

public class NavigatorView
implements IView {
    private IStructuredContentProvider[] contentProviders;
    private INavigatorContentGroup[] groups;
    private ListenerList listeners = new ListenerList(1);
    private NavigatorViewItem root = new NavigatorViewItem();

    public void dispose() {
        this.listeners.clear();
        int i = 0;
        while (i < this.contentProviders.length) {
            this.contentProviders[i].dispose();
            ++i;
        }
    }

    public IViewItem[] getItems() {
        return this.root.getItems();
    }

    public void addViewChangeListener(IViewChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeViewChangeListener(IViewChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void notifyListeners(ViewEvent event) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            Status status;
            try {
                ((IViewChangeListener)l[i]).viewChanged(event);
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipsetrader.core", 0, "Error running view listener", (Throwable)e);
                CoreActivator.log((IStatus)status);
            }
            catch (LinkageError e) {
                status = new Status(4, "org.eclipsetrader.core", 0, "Error running view listener", (Throwable)e);
                CoreActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    public IStructuredContentProvider[] getContentProviders() {
        return this.contentProviders;
    }

    public void setContentProviders(IStructuredContentProvider[] contentProviders) {
        this.contentProviders = contentProviders;
    }

    public void setGroups(INavigatorContentGroup[] groups) {
        this.groups = groups;
    }

    public INavigatorContentGroup[] getGroups() {
        return this.groups;
    }

    public void update() {
        ArrayList<Object> instruments = new ArrayList<Object>();
        if (this.contentProviders != null) {
            int i = 0;
            while (i < this.contentProviders.length) {
                instruments.addAll(Arrays.asList(this.contentProviders[i].getElements((Object)this)));
                ++i;
            }
        }
        NavigatorViewItem newRoot = new NavigatorViewItem();
        if (this.groups != null && this.groups.length != 0) {
            this.groupElements(newRoot, instruments.toArray(new IAdaptable[instruments.size()]), this.groups);
        } else {
            for (Object e : instruments) {
                newRoot.createChild(e);
            }
        }
        ViewItemDelta viewItemDelta = new ViewItemDelta(0, (IViewItem)this.root);
        this.updateTree(viewItemDelta, this.root, newRoot);
        if (viewItemDelta.getChildCount() != 0) {
            this.notifyListeners(new ViewEvent((IView)this, viewItemDelta.getChilds()));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void accept(IViewVisitor visitor) {
        if (visitor.visit((IView)this)) {
            IViewItem[] iViewItemArray = this.getItems();
            int n = iViewItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewItem viewItem = iViewItemArray[n2];
                viewItem.accept((IViewItemVisitor)visitor);
                ++n2;
            }
        }
    }

    protected void updateTree(ViewItemDelta parentDelta, NavigatorViewItem oldItem, NavigatorViewItem newItem) {
        Object reference;
        IViewItem viewItem;
        IViewItem[] iViewItemArray = oldItem.getItems();
        int n = iViewItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            viewItem = iViewItemArray[n2];
            reference = ((NavigatorViewItem)viewItem).getReference();
            if (!newItem.hasChild(reference)) {
                oldItem.removeChild(reference);
                parentDelta.createChild(viewItem, 2);
            }
            ++n2;
        }
        iViewItemArray = newItem.getItems();
        n = iViewItemArray.length;
        n2 = 0;
        while (n2 < n) {
            ViewItemDelta delta;
            viewItem = iViewItemArray[n2];
            reference = ((NavigatorViewItem)viewItem).getReference();
            if (!oldItem.hasChild(reference)) {
                NavigatorViewItem addedItem = oldItem.createChild(reference);
                delta = parentDelta.createChild((IViewItem)addedItem, 1);
                this.updateTree(delta, addedItem, (NavigatorViewItem)viewItem);
            } else {
                NavigatorViewItem existingViewItem = oldItem.getChild(reference);
                delta = parentDelta.createChild((IViewItem)existingViewItem, 0);
                this.updateTree(delta, existingViewItem, (NavigatorViewItem)viewItem);
            }
            ++n2;
        }
    }

    protected void groupElements(NavigatorViewItem parent, IAdaptable[] elements, INavigatorContentGroup[] groups) {
        ArrayList<IAdaptable> set = new ArrayList<IAdaptable>();
        set.addAll(Arrays.asList(elements));
        if (groups != null && groups.length != 0) {
            IViewItem[] groupedElements;
            INavigatorContentGroup group = groups[0];
            INavigatorContentGroup[] downGroups = null;
            if (groups.length > 1) {
                downGroups = new INavigatorContentGroup[groups.length - 1];
                System.arraycopy(groups, 1, downGroups, 0, downGroups.length);
            }
            if ((groupedElements = group.getGroupedContent(elements)).length != 0) {
                IViewItem[] iViewItemArray = groupedElements;
                int n = groupedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewItem viewItem = iViewItemArray[n2];
                    IViewItem[] iViewItemArray2 = viewItem.getItems();
                    int n3 = iViewItemArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewItem childItem = iViewItemArray2[n4];
                        Object reference = childItem.getAdapter(Object.class);
                        Iterator iter = set.iterator();
                        while (iter.hasNext()) {
                            Object obj = ((IAdaptable)iter.next()).getAdapter(reference.getClass());
                            if (obj != reference) continue;
                            iter.remove();
                        }
                        ++n4;
                    }
                    Object reference = viewItem.getAdapter(Object.class);
                    NavigatorViewItem instrumentViewItem = parent.createChild(reference);
                    this.groupElements(instrumentViewItem, (IAdaptable[])viewItem.getItems(), downGroups);
                    ++n2;
                }
            }
            if (set.size() != 0) {
                this.groupElements(parent, set.toArray(new IAdaptable[set.size()]), downGroups);
            }
        } else {
            int i = 0;
            while (i < elements.length) {
                Object reference = elements[i].getAdapter(Object.class);
                parent.createChild(reference);
                ++i;
            }
        }
    }
}

