/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.preferences;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.preferences.Messages;

public class LaunchersPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String LAUNCHERS_EXTENSION_ID = "org.eclipsetrader.core.launchers";
    CheckboxTableViewer startupLaunchers;
    Button startAllLaunchers;
    Button startSelectedLaunchers;
    CheckboxTableViewer runLaunchers;

    public LaunchersPreferences() {
        super("Launchers");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.startAllLaunchers = new Button(content, 16);
        this.startAllLaunchers.setText(Messages.LaunchersPreferences_StartAllServices);
        this.startAllLaunchers.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.startAllLaunchers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchersPreferences.this.runLaunchers.getControl().setEnabled(LaunchersPreferences.this.startSelectedLaunchers.getSelection());
            }
        });
        this.startSelectedLaunchers = new Button(content, 16);
        this.startSelectedLaunchers.setText(Messages.LaunchersPreferences_StartServicesSelectedBellow);
        this.startSelectedLaunchers.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.startSelectedLaunchers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchersPreferences.this.runLaunchers.getControl().setEnabled(LaunchersPreferences.this.startSelectedLaunchers.getSelection());
            }
        });
        this.runLaunchers = CheckboxTableViewer.newCheckList((Composite)content, (int)2048);
        this.runLaunchers.getControl().setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        ((GridData)this.runLaunchers.getControl().getLayoutData()).heightHint = this.convertHeightInCharsToPixels(6);
        this.runLaunchers.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.runLaunchers.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IConfigurationElement)element).getAttribute("name");
            }
        });
        Label label = new Label(content, 0);
        label.setText(Messages.LaunchersPreferences_ServiceLaunchedAtStartup);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.startupLaunchers = CheckboxTableViewer.newCheckList((Composite)content, (int)2048);
        this.startupLaunchers.getControl().setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        ((GridData)this.startupLaunchers.getControl().getLayoutData()).heightHint = this.convertHeightInCharsToPixels(6);
        this.startupLaunchers.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.startupLaunchers.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IConfigurationElement)element).getAttribute("name");
            }
        });
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(LAUNCHERS_EXTENSION_ID);
        if (extensionPoint != null) {
            List<IConfigurationElement> configElements = Arrays.asList(extensionPoint.getConfigurationElements());
            Collections.sort(configElements, new Comparator<IConfigurationElement>(){

                @Override
                public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                    return o1.getAttribute("name").compareToIgnoreCase(o2.getAttribute("name"));
                }
            });
            this.startupLaunchers.setInput(configElements);
            this.runLaunchers.setInput(configElements);
        }
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(LAUNCHERS_EXTENSION_ID);
        if (extensionPoint != null) {
            IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
            this.startupLaunchers.setAllChecked(false);
            this.runLaunchers.setAllChecked(false);
            HashSet<String> startupSet = new HashSet<String>(Arrays.asList(preferenceStore.getString("STARTUP_LAUNCHERS").split(";")));
            HashSet<String> runSet = new HashSet<String>(Arrays.asList(preferenceStore.getString("RUN_LAUNCHERS").split(";")));
            int i = 0;
            while (i < configElements.length) {
                String id = configElements[i].getAttribute("id");
                if (startupSet.contains(id)) {
                    this.startupLaunchers.setChecked((Object)configElements[i], true);
                }
                if (runSet.contains(id)) {
                    this.runLaunchers.setChecked((Object)configElements[i], true);
                }
                ++i;
            }
        }
        this.startAllLaunchers.setSelection(preferenceStore.getBoolean("RUN_ALL_LAUNCHERS"));
        this.startSelectedLaunchers.setSelection(!this.startAllLaunchers.getSelection());
        this.runLaunchers.getControl().setEnabled(this.startSelectedLaunchers.getSelection());
        super.performDefaults();
    }

    public boolean performOk() {
        String id;
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        StringBuffer sb = new StringBuffer();
        Object[] o = this.startupLaunchers.getCheckedElements();
        int i = 0;
        while (i < o.length) {
            id = ((IConfigurationElement)o[i]).getAttribute("id");
            if (i != 0) {
                sb.append(";");
            }
            sb.append(id);
            ++i;
        }
        preferenceStore.setValue("STARTUP_LAUNCHERS", sb.toString());
        sb = new StringBuffer();
        o = this.runLaunchers.getCheckedElements();
        i = 0;
        while (i < o.length) {
            id = ((IConfigurationElement)o[i]).getAttribute("id");
            if (i != 0) {
                sb.append(";");
            }
            sb.append(id);
            ++i;
        }
        preferenceStore.setValue("RUN_LAUNCHERS", sb.toString());
        preferenceStore.setValue("RUN_ALL_LAUNCHERS", this.startAllLaunchers.getSelection());
        return super.performOk();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return UIActivator.getDefault().getPreferenceStore();
    }
}

