/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.preferences;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.charts.Period;
import org.eclipsetrader.ui.internal.charts.PeriodList;
import org.eclipsetrader.ui.internal.preferences.Messages;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IEclipsePreferences node = DefaultScope.INSTANCE.getNode("org.eclipsetrader.ui");
        node.putBoolean("WATCHLIST_ALTERNATE_BACKGROUND", true);
        node.putBoolean("WATCHLIST_ENABLE_TICK_DECORATORS", true);
        node.putBoolean("WATCHLIST_DRAW_TICK_OUTLINE", true);
        node.putBoolean("WATCHLIST_FADE_TO_BACKGROUND", false);
        IPreferenceStore preferences = UIActivator.getDefault().getPreferenceStore();
        PeriodList list = new PeriodList();
        list.add(new Period(Messages.PreferenceInitializer_2Years, TimeSpan.years((int)2), TimeSpan.days((int)1)));
        list.add(new Period(Messages.PreferenceInitializer_1Year, TimeSpan.years((int)1), TimeSpan.days((int)1)));
        list.add(new Period(Messages.PreferenceInitializer_6Months, TimeSpan.months((int)6), TimeSpan.minutes((int)30)));
        list.add(new Period(Messages.PreferenceInitializer_3Months, TimeSpan.months((int)3), TimeSpan.minutes((int)30)));
        list.add(new Period(Messages.PreferenceInitializer_1Month, TimeSpan.months((int)1), TimeSpan.minutes((int)15)));
        list.add(new Period(Messages.PreferenceInitializer_5Days, TimeSpan.days((int)5), TimeSpan.minutes((int)5)));
        list.add(new Period(Messages.PreferenceInitializer_1Day, TimeSpan.days((int)1), TimeSpan.minutes((int)1)));
        try {
            preferences.setDefault("CHART_PERIODS", this.marshal(list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TimeSpan.days((int)1)).append(",");
        sb.append(TimeSpan.minutes((int)1)).append(",");
        sb.append(TimeSpan.minutes((int)5)).append(",");
        sb.append(TimeSpan.minutes((int)10)).append(",");
        sb.append(TimeSpan.minutes((int)15)).append(",");
        sb.append(TimeSpan.minutes((int)30)).append(",");
        sb.append(TimeSpan.minutes((int)60));
        preferences.setDefault("CHART_BARS", sb.toString());
    }

    private String marshal(PeriodList object) throws Exception {
        StringWriter string = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)object, (Writer)string);
        return string.toString();
    }
}

