/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.preferences;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.preferences.Messages;

public class WatchListPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button alternateBackground;
    private Button enableTickDecorator;
    private ColorSelector positiveTickColor;
    private ColorSelector negativeTickColor;
    private Button drawTickOutline;
    private Button fadeToBackground;
    private ITheme theme;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(UIActivator.getDefault().getPreferenceStore());
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        this.theme = themeManager.getCurrentTheme();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.alternateBackground = new Button(content, 32);
        this.alternateBackground.setText(Messages.WatchListPreferencesPage_AlternateRowsBackground);
        this.alternateBackground.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.enableTickDecorator = new Button(content, 32);
        this.enableTickDecorator.setText(Messages.WatchListPreferencesPage_EnableHilights);
        this.enableTickDecorator.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.enableTickDecorator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WatchListPreferencesPage.this.updateControlsEnablement();
            }
        });
        Label label = new Label(content, 0);
        label.setText(Messages.WatchListPreferencesPage_PositiveHighlight);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)label.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(18);
        this.positiveTickColor = new ColorSelector(content);
        label = new Label(content, 0);
        label.setText(Messages.WatchListPreferencesPage_NegativeHighlight);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)label.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(18);
        this.negativeTickColor = new ColorSelector(content);
        this.drawTickOutline = new Button(content, 32);
        this.drawTickOutline.setText(Messages.WatchListPreferencesPage_HilightOutline);
        this.drawTickOutline.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        ((GridData)this.drawTickOutline.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(18);
        this.fadeToBackground = new Button(content, 32);
        this.fadeToBackground.setText(Messages.WatchListPreferencesPage_FadeToBackground);
        this.fadeToBackground.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        ((GridData)this.fadeToBackground.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(18);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.alternateBackground.setSelection(preferenceStore.getBoolean("WATCHLIST_ALTERNATE_BACKGROUND"));
        this.enableTickDecorator.setSelection(preferenceStore.getBoolean("WATCHLIST_ENABLE_TICK_DECORATORS"));
        this.positiveTickColor.setColorValue(this.theme.getColorRegistry().getRGB("WATCHLIST_POSITIVE_TICK_COLOR"));
        this.negativeTickColor.setColorValue(this.theme.getColorRegistry().getRGB("WATCHLIST_NEGATIVE_TICK_COLOR"));
        this.drawTickOutline.setSelection(preferenceStore.getBoolean("WATCHLIST_DRAW_TICK_OUTLINE"));
        this.fadeToBackground.setSelection(preferenceStore.getBoolean("WATCHLIST_FADE_TO_BACKGROUND"));
        this.updateControlsEnablement();
        return content;
    }

    private void updateControlsEnablement() {
        this.positiveTickColor.setEnabled(this.enableTickDecorator.getSelection());
        this.negativeTickColor.setEnabled(this.enableTickDecorator.getSelection());
        this.drawTickOutline.setEnabled(this.enableTickDecorator.getSelection());
        this.fadeToBackground.setEnabled(this.enableTickDecorator.getSelection());
    }

    protected void performDefaults() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        ITheme theme = this.getTheme();
        this.alternateBackground.setSelection(preferenceStore.getDefaultBoolean("WATCHLIST_ALTERNATE_BACKGROUND"));
        this.enableTickDecorator.setSelection(preferenceStore.getDefaultBoolean("WATCHLIST_ENABLE_TICK_DECORATORS"));
        this.drawTickOutline.setSelection(preferenceStore.getDefaultBoolean("WATCHLIST_DRAW_TICK_OUTLINE"));
        this.fadeToBackground.setSelection(preferenceStore.getDefaultBoolean("WATCHLIST_FADE_TO_BACKGROUND"));
        this.positiveTickColor.setColorValue(theme.getColorRegistry().getRGB("WATCHLIST_POSITIVE_TICK_COLOR"));
        this.negativeTickColor.setColorValue(theme.getColorRegistry().getRGB("WATCHLIST_NEGATIVE_TICK_COLOR"));
        this.updateControlsEnablement();
        super.performDefaults();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performApply() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        ITheme theme = this.getTheme();
        preferenceStore.setValue("WATCHLIST_ALTERNATE_BACKGROUND", this.alternateBackground.getSelection());
        preferenceStore.setValue("WATCHLIST_ENABLE_TICK_DECORATORS", this.enableTickDecorator.getSelection());
        preferenceStore.setValue("WATCHLIST_DRAW_TICK_OUTLINE", this.drawTickOutline.getSelection());
        preferenceStore.setValue("WATCHLIST_FADE_TO_BACKGROUND", this.fadeToBackground.getSelection());
        theme.getColorRegistry().put("WATCHLIST_POSITIVE_TICK_COLOR", this.positiveTickColor.getColorValue());
        theme.getColorRegistry().put("WATCHLIST_NEGATIVE_TICK_COLOR", this.negativeTickColor.getColorValue());
    }

    public ITheme getTheme() {
        return this.theme;
    }

    public void setTheme(ITheme theme) {
        this.theme = theme;
    }
}

