/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class AskPriceFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();

    public AskPriceFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(2);
        this.formatter.setMaximumFractionDigits(4);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Double.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return AskPriceFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            IQuote quote = (IQuote)adaptable.getAdapter(IQuote.class);
            if (quote != null && quote.getAsk() != null) {
                Double value = quote.getAsk();
                return new NumberValue(value, AskPriceFactory.this.formatter.format(value));
            }
            return null;
        }

        public void dispose() {
        }
    }
}

