/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class BidAskSpreadFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();

    public BidAskSpreadFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumFractionDigits(2);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Double.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return BidAskSpreadFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            IQuote quote = (IQuote)adaptable.getAdapter(IQuote.class);
            if (quote == null || quote.getBid() == null || quote.getAsk() == null) {
                return null;
            }
            if (quote.getBid() == 0.0 || quote.getAsk() == 0.0) {
                return null;
            }
            Double result = Math.abs((quote.getAsk() - quote.getBid()) / quote.getBid() * 100.0);
            return new NumberValue(result, String.valueOf(BidAskSpreadFactory.this.formatter.format(result)) + "%");
        }

        public void dispose() {
        }
    }
}

