/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IPrice;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class ChangeAmountFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();
    private Color positiveColor = Display.getDefault().getSystemColor(5);
    private Color negativeColor = Display.getDefault().getSystemColor(3);

    public ChangeAmountFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(2);
        this.formatter.setMaximumFractionDigits(4);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Double.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return ChangeAmountFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ILastClose close = (ILastClose)adaptable.getAdapter(ILastClose.class);
            IPrice price = (IPrice)adaptable.getAdapter(IPrice.class);
            if (close != null && close.getPrice() != null && price != null && price.getPrice() != null) {
                Double value = price.getPrice() - close.getPrice();
                Color color = value != 0.0 ? (value > 0.0 ? ChangeAmountFactory.this.positiveColor : ChangeAmountFactory.this.negativeColor) : null;
                return new NumberValue(value, String.valueOf(value > 0.0 ? "+" : "") + ChangeAmountFactory.this.formatter.format(value), color);
            }
            return null;
        }

        public void dispose() {
        }
    }
}

