/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.GainValue;

public class GainFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();
    private NumberFormat percentageFormatter = NumberFormat.getInstance();
    private Color positiveColor = Display.getDefault().getSystemColor(5);
    private Color negativeColor = Display.getDefault().getSystemColor(3);

    public GainFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(2);
        this.percentageFormatter.setGroupingUsed(true);
        this.percentageFormatter.setMinimumIntegerDigits(1);
        this.percentageFormatter.setMinimumFractionDigits(2);
        this.percentageFormatter.setMaximumFractionDigits(2);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Long.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return GainFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ITrade trade = (ITrade)adaptable.getAdapter(ITrade.class);
            if (trade == null || trade.getPrice() == null || trade.getPrice() == 0.0) {
                return null;
            }
            IHolding holding = (IHolding)adaptable.getAdapter(IHolding.class);
            if (holding != null && holding.getPosition() != null && holding.getPurchasePrice() != null) {
                Double purchaseValue = (double)holding.getPosition().longValue() * holding.getPurchasePrice();
                Double marketValue = (double)holding.getPosition().longValue() * trade.getPrice();
                Double value = marketValue - purchaseValue;
                Double percentage = value / purchaseValue * 100.0;
                String text = String.valueOf(value > 0.0 ? "+" : "") + GainFactory.this.formatter.format(value) + " (" + (value > 0.0 ? "+" : "") + GainFactory.this.percentageFormatter.format(percentage) + "%)";
                Color color = value != 0.0 ? (value > 0.0 ? GainFactory.this.positiveColor : GainFactory.this.negativeColor) : null;
                return new GainValue(value, purchaseValue, marketValue, text, color);
            }
            IPosition position = (IPosition)adaptable.getAdapter(IPosition.class);
            if (position != null && position.getQuantity() != null && position.getPrice() != null) {
                Double purchaseValue = (double)position.getQuantity().longValue() * position.getPrice();
                Double marketValue = (double)position.getQuantity().longValue() * trade.getPrice();
                Double value = marketValue - purchaseValue;
                Double percentage = value / purchaseValue * 100.0;
                String text = String.valueOf(value > 0.0 ? "+" : "") + GainFactory.this.formatter.format(value) + " (" + (value > 0.0 ? "+" : "") + GainFactory.this.percentageFormatter.format(percentage) + "%)";
                Color color = value != 0.0 ? (value > 0.0 ? GainFactory.this.positiveColor : GainFactory.this.negativeColor) : null;
                return new GainValue(value, purchaseValue, marketValue, text, color);
            }
            return null;
        }

        public void dispose() {
        }
    }
}

