/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.feed.ITodayOHL;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class HighestPriceFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();

    public HighestPriceFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(2);
        this.formatter.setMaximumFractionDigits(4);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Double.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return HighestPriceFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ITodayOHL todayOHL = (ITodayOHL)adaptable.getAdapter(ITodayOHL.class);
            if (todayOHL != null && todayOHL.getHigh() != null) {
                Double value = todayOHL.getHigh();
                return new NumberValue(value, HighestPriceFactory.this.formatter.format(value));
            }
            return null;
        }

        public void dispose() {
        }
    }
}

