/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class LastTradePriceFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();

    public LastTradePriceFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(2);
        this.formatter.setMaximumFractionDigits(4);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Double.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return LastTradePriceFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ITrade trade = (ITrade)adaptable.getAdapter(ITrade.class);
            if (trade != null && trade.getPrice() != null) {
                return new NumberValue(trade.getPrice(), LastTradePriceFactory.this.formatter.format(trade.getPrice()));
            }
            return null;
        }

        public void dispose() {
        }
    }
}

