/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;
import org.eclipsetrader.ui.internal.providers.NumberValue;

public class MarketValueFactory
extends AbstractProviderFactory {
    private NumberFormat formatter = NumberFormat.getInstance();

    public MarketValueFactory() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(2);
        this.formatter.setMaximumFractionDigits(2);
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Double.class, String.class};
    }

    public class DataProvider
    implements IDataProvider {
        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return MarketValueFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ITrade trade = (ITrade)adaptable.getAdapter(ITrade.class);
            if (trade == null || trade.getPrice() == null) {
                return null;
            }
            IHolding holding = (IHolding)adaptable.getAdapter(IHolding.class);
            if (holding != null && holding.getPosition() != null) {
                Double value = trade.getPrice() * (double)holding.getPosition().longValue();
                return new NumberValue(value, MarketValueFactory.this.formatter.format(value));
            }
            IPosition position = (IPosition)adaptable.getAdapter(IPosition.class);
            if (position != null && position.getQuantity() != null) {
                Double value = trade.getPrice() * position.getPrice();
                return new NumberValue(value, MarketValueFactory.this.formatter.format(value));
            }
            return null;
        }

        public void dispose() {
        }
    }
}

