/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.IBookEntry;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;

public class PressureBarFactory
extends AbstractProviderFactory {
    private static final int IMAGE_WIDTH = 128;
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_HALF_WIDTH = 64;
    private Color bidColor = Display.getDefault().getSystemColor(3);
    private Color bidFillColor = new Color((Device)Display.getDefault(), this.blend(this.bidColor.getRGB(), new RGB(0, 0, 0), 75));
    private Color askColor = Display.getDefault().getSystemColor(5);
    private Color askFillColor = new Color((Device)Display.getDefault(), this.blend(this.askColor.getRGB(), new RGB(0, 0, 0), 75));
    private Color backgroundColor = Display.getDefault().getSystemColor(1);

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Image.class};
    }

    protected void buildValue(IBook book, Image image) {
        int level = 0;
        double currentPrice = 0.0;
        double bidPressure = 0.0;
        IBookEntry[] iBookEntryArray = book.getBidProposals();
        int n = iBookEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBookEntry entry = iBookEntryArray[n2];
            if (currentPrice != entry.getPrice()) {
                currentPrice = entry.getPrice();
                if (++level > 5) break;
            }
            bidPressure += (double)entry.getQuantity().longValue();
            ++n2;
        }
        level = 0;
        currentPrice = 0.0;
        double askPressure = 0.0;
        IBookEntry[] iBookEntryArray2 = book.getAskProposals();
        int n3 = iBookEntryArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            IBookEntry entry = iBookEntryArray2[n4];
            if (currentPrice != entry.getPrice()) {
                currentPrice = entry.getPrice();
                if (++level > 5) break;
            }
            askPressure += (double)entry.getQuantity().longValue();
            ++n4;
        }
        int bidPixels = (int)(bidPressure / (bidPressure + askPressure) * 64.0);
        int askPixels = (int)(askPressure / (bidPressure + askPressure) * 64.0);
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(this.backgroundColor);
            gc.fillRectangle(0, 0, 128, 16);
            gc.setBackground(this.bidFillColor);
            gc.fillRectangle(64 - bidPixels, 0, bidPixels, 16);
            gc.setBackground(this.askFillColor);
            gc.fillRectangle(64, 0, askPixels, 16);
            gc.setLineWidth(2);
            gc.setForeground(this.bidColor);
            gc.drawLine(64 - bidPixels - 1, 1, 64, 1);
            gc.drawLine(64 - bidPixels - 1, 0, 64 - bidPixels, 15);
            gc.drawLine(64 - bidPixels - 1, 15, 64, 15);
            gc.setForeground(this.askColor);
            gc.drawLine(64, 1, 64 + askPixels, 1);
            gc.drawLine(64 + askPixels - 1, 0, 64 + askPixels - 1, 15);
            gc.drawLine(64, 15, 64 + askPixels, 15);
        }
        finally {
            gc.dispose();
        }
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    private class Data {
        IBook book;
        Image image;
        ImageDataValue value;

        private Data() {
        }
    }

    public class DataProvider
    implements IDataProvider {
        private MarketPricingEnvironment pricingEnvironment;
        private Map<ISecurity, Data> map = new HashMap<ISecurity, Data>();

        public void init(IAdaptable adaptable) {
            ISecurity security = (ISecurity)adaptable.getAdapter(ISecurity.class);
            if (!this.map.containsKey(security)) {
                this.pricingEnvironment = (MarketPricingEnvironment)adaptable.getAdapter(MarketPricingEnvironment.class);
                if (this.pricingEnvironment != null) {
                    this.pricingEnvironment.addLevel2Security(security);
                }
                Data data = new Data();
                data.image = new Image((Device)Display.getDefault(), 128, 16);
                this.map.put(security, data);
            }
        }

        public void dispose() {
            for (Data data : this.map.values()) {
                data.image.dispose();
            }
            this.map.clear();
        }

        public IDataProviderFactory getFactory() {
            return PressureBarFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ISecurity security = (ISecurity)adaptable.getAdapter(ISecurity.class);
            Data data = this.map.get(security);
            if (data == null) {
                return null;
            }
            IBook newBook = (IBook)adaptable.getAdapter(IBook.class);
            if (newBook != null && !newBook.equals(data.book)) {
                PressureBarFactory.this.buildValue(newBook, data.image);
                data.book = newBook;
                data.value = new ImageDataValue(data.image.getImageData());
            }
            return data.value;
        }
    }

    public static class ImageDataValue
    implements IAdaptable {
        private final ImageData value;

        public ImageDataValue(ImageData value) {
            this.value = value;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(ImageData.class)) {
                return this.value;
            }
            return null;
        }
    }
}

