/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.providers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.providers.AbstractProviderFactory;

public class TrendFactory
extends AbstractProviderFactory {
    private Image stable;
    private Image up;
    private Image down;

    public TrendFactory() {
        ImageRegistry registry = UIActivator.getDefault().getImageRegistry();
        this.stable = registry.get("trend_stable");
        this.up = registry.get("trend_up");
        this.down = registry.get("trend_down");
    }

    public IDataProvider createProvider() {
        return new DataProvider();
    }

    public Class[] getType() {
        return new Class[]{Image.class};
    }

    protected int compareValues(Number o1, Number o2) {
        if (o1 != null && o2 != null) {
            if (o1.doubleValue() < o2.doubleValue()) {
                return -1;
            }
            if (o1.doubleValue() > o2.doubleValue()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    protected double getSlope(Double[] values) {
        int numberPlotPoints = 0;
        double sumxx = 0.0;
        double sumxy = 0.0;
        double sumx = 0.0;
        double sumy = 0.0;
        int i = 0;
        while (i < values.length) {
            double x = numberPlotPoints;
            double y = values[i];
            sumx += x;
            sumy += y;
            sumxx += x * x;
            sumxy += x * y;
            ++i;
            ++numberPlotPoints;
        }
        double n = numberPlotPoints;
        double Sxx = sumxx - sumx * sumx / n;
        double Sxy = sumxy - sumx * sumy / n;
        double b = Sxy / Sxx;
        return b;
    }

    public class DataProvider
    implements IDataProvider {
        private Map<IAdaptable, List<Double>> values = new HashMap<IAdaptable, List<Double>>();

        public void init(IAdaptable adaptable) {
        }

        public IDataProviderFactory getFactory() {
            return TrendFactory.this;
        }

        public IAdaptable getValue(IAdaptable adaptable) {
            ITrade trade = (ITrade)adaptable.getAdapter(ITrade.class);
            if (trade != null && trade.getPrice() != null && trade.getTime() != null) {
                double direction;
                Double oldTrade;
                List<Double> oldTrades = this.values.get(adaptable);
                if (oldTrades == null) {
                    oldTrades = new ArrayList<Double>();
                    this.values.put(adaptable, oldTrades);
                }
                Double d = oldTrade = oldTrades.size() != 0 ? oldTrades.get(oldTrades.size() - 1) : null;
                if (oldTrade == null || !oldTrade.equals(trade.getPrice())) {
                    oldTrades.add(trade.getPrice());
                    if (oldTrades.size() > 5) {
                        oldTrades.remove(0);
                    }
                }
                double d2 = direction = oldTrades.size() > 1 ? TrendFactory.this.getSlope(oldTrades.toArray(new Double[oldTrades.size()])) : 0.0;
                Image value = direction == 0.0 ? TrendFactory.this.stable : (direction < 0.0 ? TrendFactory.this.down : TrendFactory.this.up);
                return new ImageValue(value);
            }
            return null;
        }

        public void dispose() {
        }
    }

    public static class ImageValue
    implements IAdaptable {
        private final Image value;

        public ImageValue(Image value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IAdaptable)) {
                return false;
            }
            Image s = (Image)((IAdaptable)obj).getAdapter(Image.class);
            return s == this.value;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(Image.class)) {
                return this.value;
            }
            return null;
        }
    }
}

