/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.repositories;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.repositories.OthersContainerObject;
import org.eclipsetrader.ui.internal.repositories.SecurityContainerObject;
import org.eclipsetrader.ui.internal.repositories.WatchListContainerObject;

public class RepositoryLabelProvider
extends LabelProvider
implements IFontProvider {
    private Font repositoryFont;
    private Font categoryFont;
    private Image repositoryIcon = UIActivator.getDefault().getImageRegistry().get("repository");
    private Image securityFolderIcon = UIActivator.getDefault().getImageRegistry().get("repository_object_fldr");
    private Image securityIcon = UIActivator.getDefault().getImageRegistry().get("repository_object");

    public RepositoryLabelProvider() {
        FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
        if (fontData != null && fontData.length != 0) {
            this.repositoryFont = new Font((Device)Display.getDefault(), fontData[0].getName(), fontData[0].getHeight(), 1);
            this.categoryFont = new Font((Device)Display.getDefault(), fontData[0].getName(), fontData[0].getHeight(), 1);
        }
    }

    public void dispose() {
        if (this.repositoryFont != null) {
            this.repositoryFont.dispose();
        }
        if (this.categoryFont != null) {
            this.categoryFont.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof IAdaptable) {
            element = ((IAdaptable)element).getAdapter(Object.class);
        }
        if (element instanceof IRepository) {
            return this.repositoryIcon;
        }
        if (element instanceof SecurityContainerObject || element instanceof WatchListContainerObject || element instanceof OthersContainerObject) {
            return this.securityFolderIcon;
        }
        return this.securityIcon;
    }

    public String getText(Object element) {
        if (element instanceof IAdaptable) {
            element = ((IAdaptable)element).getAdapter(Object.class);
        }
        if (element instanceof IRepository) {
            return ((IRepository)element).toString();
        }
        if (element instanceof ISecurity) {
            return ((ISecurity)element).getName();
        }
        if (element instanceof IWatchList) {
            return ((IWatchList)element).getName();
        }
        return element != null ? element.toString() : "";
    }

    public Font getFont(Object element) {
        if (element instanceof IAdaptable) {
            element = ((IAdaptable)element).getAdapter(Object.class);
        }
        if (element instanceof IRepository) {
            return this.repositoryFont;
        }
        if (element instanceof SecurityContainerObject || element instanceof WatchListContainerObject || element instanceof OthersContainerObject) {
            return this.categoryFont;
        }
        return null;
    }
}

