/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.repositories;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;

public class RepositoryViewItem
implements IViewItem {
    private Object object;
    private IAdaptable[] values = new IAdaptable[0];
    private RepositoryViewItem parent;
    private Map<Object, RepositoryViewItem> childs = new HashMap<Object, RepositoryViewItem>();

    public RepositoryViewItem() {
    }

    protected RepositoryViewItem(RepositoryViewItem parent, Object object) {
        this.parent = parent;
        this.object = object;
        this.values = new IAdaptable[]{new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (RepositoryViewItem.this.object != null) {
                    if (adapter.isAssignableFrom(RepositoryViewItem.this.object.getClass())) {
                        return RepositoryViewItem.this.object;
                    }
                    if (adapter.isAssignableFrom(String.class)) {
                        return RepositoryViewItem.this.object.toString();
                    }
                }
                return null;
            }
        }};
    }

    public int getItemCount() {
        return this.childs != null ? this.childs.size() : 0;
    }

    public IViewItem[] getItems() {
        Collection<RepositoryViewItem> c = this.childs.values();
        return c.toArray(new IViewItem[c.size()]);
    }

    public IViewItem getParent() {
        return this.parent;
    }

    public boolean hasChild(Object object) {
        return this.childs.containsKey(object);
    }

    public RepositoryViewItem getChild(Object object) {
        return this.childs.get(object);
    }

    public RepositoryViewItem createChild(Object object) {
        RepositoryViewItem viewItem = new RepositoryViewItem(this, object);
        this.childs.put(object, viewItem);
        return viewItem;
    }

    public void removeChild(Object object) {
        this.childs.remove(object);
    }

    public Iterator<RepositoryViewItem> iterator() {
        return this.childs.values().iterator();
    }

    public IAdaptable[] getValues() {
        return this.values;
    }

    public void setValues(IAdaptable[] values) {
        this.values = values;
    }

    public Object getObject() {
        return this.object;
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (this.object != null && adapter.isAssignableFrom(this.object.getClass())) {
            return this.object;
        }
        if (this.object instanceof IAdaptable && (obj = ((IAdaptable)this.object).getAdapter(adapter)) != null) {
            return obj;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (this.object instanceof IAdaptable) {
            return AdapterManager.getDefault().getAdapter(this.object, adapter);
        }
        return null;
    }

    public void accept(IViewItemVisitor visitor) {
        if (visitor.visit((IViewItem)this)) {
            IViewItem[] iViewItemArray = this.getItems();
            int n = iViewItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewItem viewItem = iViewItemArray[n2];
                viewItem.accept(visitor);
                ++n2;
            }
        }
    }

    public int hashCode() {
        return 7 * (this.object != null ? this.object.hashCode() : 0) + 11 * (this.parent != null ? this.parent.hashCode() : 0);
    }
}

