/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.feed.IBackfillConnector;
import org.eclipsetrader.core.feed.IConnectorOverride;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.feed.ConnectorOverride;
import org.eclipsetrader.core.internal.feed.ConnectorOverrideAdapter;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.properties.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConnectorOverrideProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    Button liveFeedOverride;
    ComboViewer liveFeed;
    Button backfillFeedOverride;
    ComboViewer backfillFeed;
    Button intradayBackfillFeedOverride;
    ComboViewer intradayBackfillFeed;

    public ConnectorOverrideProperties() {
        this.setTitle(Messages.ConnectorOverrideProperties_Overrides);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.liveFeedOverride = new Button(content, 32);
        this.liveFeedOverride.setText(Messages.ConnectorOverrideProperties_LiveFeed);
        this.liveFeedOverride.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectorOverrideProperties.this.liveFeed.getControl().setEnabled(ConnectorOverrideProperties.this.liveFeedOverride.getSelection());
            }
        });
        this.liveFeed = new ComboViewer(content, 8);
        this.liveFeed.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.liveFeed.getControl().getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(32);
        this.liveFeed.getCombo().setVisibleItemCount(15);
        this.liveFeed.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IFeedConnector)) {
                    IFeedConnector defaultConnector = CoreActivator.getDefault() != null ? CoreActivator.getDefault().getDefaultConnector() : null;
                    return NLS.bind((String)Messages.ConnectorOverrideProperties_Default, (Object[])new Object[]{defaultConnector != null ? defaultConnector.getName() : Messages.ConnectorOverrideProperties_None});
                }
                return ((IFeedConnector)element).getName();
            }
        });
        this.liveFeed.setSorter(new ViewerSorter());
        this.liveFeed.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.backfillFeedOverride = new Button(content, 32);
        this.backfillFeedOverride.setText(Messages.ConnectorOverrideProperties_HistoryBackfill);
        this.backfillFeedOverride.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectorOverrideProperties.this.backfillFeed.getControl().setEnabled(ConnectorOverrideProperties.this.backfillFeedOverride.getSelection());
            }
        });
        this.backfillFeed = new ComboViewer(content, 8);
        this.backfillFeed.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.backfillFeed.getControl().getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(32);
        this.backfillFeed.getCombo().setVisibleItemCount(15);
        this.backfillFeed.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IBackfillConnector)) {
                    return Messages.ConnectorOverrideProperties_None;
                }
                return ((IBackfillConnector)element).getName();
            }
        });
        this.backfillFeed.setSorter(new ViewerSorter());
        this.backfillFeed.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.intradayBackfillFeedOverride = new Button(content, 32);
        this.intradayBackfillFeedOverride.setText(Messages.ConnectorOverrideProperties_IntradayBackfill);
        this.intradayBackfillFeedOverride.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectorOverrideProperties.this.intradayBackfillFeed.getControl().setEnabled(ConnectorOverrideProperties.this.intradayBackfillFeedOverride.getSelection());
            }
        });
        this.intradayBackfillFeed = new ComboViewer(content, 8);
        this.intradayBackfillFeed.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.intradayBackfillFeed.getControl().getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(32);
        this.intradayBackfillFeed.getCombo().setVisibleItemCount(15);
        this.intradayBackfillFeed.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IBackfillConnector)) {
                    Object o = ((IStructuredSelection)ConnectorOverrideProperties.this.backfillFeed.getSelection()).getFirstElement();
                    return NLS.bind((String)Messages.ConnectorOverrideProperties_Default, (Object[])new Object[]{o instanceof IBackfillConnector ? ((IBackfillConnector)o).getName() : Messages.ConnectorOverrideProperties_None});
                }
                return ((IBackfillConnector)element).getName();
            }
        });
        this.intradayBackfillFeed.setSorter(new ViewerSorter());
        this.intradayBackfillFeed.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<IFeedConnector> feedConnectors = new ArrayList<IFeedConnector>();
        if (this.getFeedService() != null) {
            feedConnectors.addAll(Arrays.asList(this.getFeedService().getConnectors()));
        }
        this.liveFeed.setInput((Object)feedConnectors.toArray());
        ArrayList<IBackfillConnector> backfillConnectors = new ArrayList<IBackfillConnector>();
        if (this.getFeedService() != null) {
            backfillConnectors.addAll(Arrays.asList(this.getFeedService().getBackfillConnectors()));
        }
        this.backfillFeed.setInput((Object)backfillConnectors.toArray());
        this.intradayBackfillFeed.setInput((Object)backfillConnectors.toArray());
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        IConnectorOverride override = (IConnectorOverride)AdapterManager.getDefault().getAdapter((Object)security, IConnectorOverride.class);
        if (override != null) {
            this.liveFeed.setSelection((ISelection)(override.getLiveFeedConnector() != null ? new StructuredSelection((Object)override.getLiveFeedConnector()) : StructuredSelection.EMPTY));
            this.backfillFeed.setSelection((ISelection)(override.getBackfillConnector() != null ? new StructuredSelection((Object)override.getBackfillConnector()) : StructuredSelection.EMPTY));
            this.intradayBackfillFeed.setSelection((ISelection)(override.getIntradayBackfillConnector() != null ? new StructuredSelection((Object)override.getIntradayBackfillConnector()) : StructuredSelection.EMPTY));
        }
        this.liveFeedOverride.setSelection(!this.liveFeed.getSelection().isEmpty());
        this.liveFeed.getControl().setEnabled(this.liveFeedOverride.getSelection());
        this.backfillFeedOverride.setSelection(!this.backfillFeed.getSelection().isEmpty());
        this.backfillFeed.getControl().setEnabled(this.backfillFeedOverride.getSelection());
        this.intradayBackfillFeedOverride.setSelection(!this.intradayBackfillFeed.getSelection().isEmpty());
        this.intradayBackfillFeed.getControl().setEnabled(this.intradayBackfillFeedOverride.getSelection());
        super.performDefaults();
    }

    protected void applyChanges() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        ConnectorOverrideAdapter adapter = (ConnectorOverrideAdapter)AdapterManager.getDefault().getAdapter((Object)security, ConnectorOverrideAdapter.class);
        if (!(this.liveFeedOverride.getSelection() || this.backfillFeedOverride.getSelection() || this.intradayBackfillFeedOverride.getSelection())) {
            adapter.clearOverride(security);
        } else {
            ConnectorOverride override = new ConnectorOverride(security);
            IStructuredSelection selection = (IStructuredSelection)this.liveFeed.getSelection();
            override.setLiveFeedConnector((IFeedConnector)selection.getFirstElement());
            selection = (IStructuredSelection)this.backfillFeed.getSelection();
            override.setBackfillConnector((IBackfillConnector)selection.getFirstElement());
            selection = (IStructuredSelection)this.intradayBackfillFeed.getSelection();
            override.setIntradayBackfillConnector((IBackfillConnector)selection.getFirstElement());
            adapter.addOverride(override);
        }
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected IFeedService getFeedService() {
        if (UIActivator.getDefault() == null) {
            return null;
        }
        try {
            BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IFeedService.class.getName());
            IFeedService service = (IFeedService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.ui", 0, Messages.ConnectorOverrideProperties_ErrorReadingFeedService, (Throwable)e);
            UIActivator.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }
}

