/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.properties;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.feed.Dividend;
import org.eclipsetrader.core.feed.IDividend;
import org.eclipsetrader.core.instruments.IStock;
import org.eclipsetrader.core.instruments.Stock;
import org.eclipsetrader.ui.DateCellEditor;
import org.eclipsetrader.ui.DoubleCellEditor;
import org.eclipsetrader.ui.Util;
import org.eclipsetrader.ui.internal.securities.properties.Messages;

public class DividendsProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    TableViewer viewer;
    Button add;
    Button remove;
    List<IDividend> input;
    DateFormat dateFormat = Util.getDateFormat();
    NumberFormat numberFormat = NumberFormat.getInstance();

    public DividendsProperties() {
        this.setTitle(Messages.DividendsProperties_Dividents);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.viewer = new TableViewer(content, 68098);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(false);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.viewer.getControl().getLayoutData()).heightHint = this.viewer.getTable().getItemHeight() * 5;
        TableColumn tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.DividendsProperties_ExDate);
        tableColumn.setWidth(this.convertHorizontalDLUsToPixels(70));
        tableColumn = new TableColumn(this.viewer.getTable(), 0);
        tableColumn.setText(Messages.DividendsProperties_Amount);
        tableColumn.setWidth(this.convertHorizontalDLUsToPixels(70));
        this.viewer.setLabelProvider((IBaseLabelProvider)new DividendLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((IDividend)e1).getExDate().compareTo(((IDividend)e2).getExDate());
            }
        });
        this.viewer.setCellModifier((ICellModifier)new DividendCellModifier());
        this.viewer.setColumnProperties(new String[]{"ex-date", "amount"});
        this.viewer.setCellEditors(new CellEditor[]{new DateCellEditor((Composite)this.viewer.getTable()), new DoubleCellEditor((Composite)this.viewer.getTable())});
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DividendsProperties.this.remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.createButtonsGroup(content);
        this.performDefaults();
        return content;
    }

    void createButtonsGroup(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, false, false));
        this.add = new Button(content, 8);
        this.add.setText(Messages.DividendsProperties_Add);
        this.add.setLayoutData((Object)new GridData(4, 4, false, false));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DividendsProperties.this.input.add((IDividend)new Dividend(new Date(), 0.0));
                DividendsProperties.this.viewer.refresh();
            }
        });
        this.remove = new Button(content, 8);
        this.remove.setText(Messages.DividendsProperties_Remove);
        this.remove.setLayoutData((Object)new GridData(4, 4, false, false));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DividendsProperties.this.viewer.getSelection();
                DividendsProperties.this.input.removeAll(selection.toList());
                DividendsProperties.this.viewer.refresh();
            }
        });
        this.remove.setEnabled(false);
    }

    protected void performDefaults() {
        IStock security = (IStock)this.getElement().getAdapter(IStock.class);
        this.input = new ArrayList<IDividend>();
        IDividend[] dividends = security.getDividends();
        if (dividends != null) {
            this.input.addAll(Arrays.asList(dividends));
        }
        this.viewer.setInput(this.input);
        super.performDefaults();
    }

    protected void applyChanges() {
        Stock security = (Stock)this.getElement().getAdapter(Stock.class);
        security.setDividends(this.input.toArray(new IDividend[this.input.size()]));
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        super.performApply();
    }

    class DividendCellModifier
    implements ICellModifier {
        DividendCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return element instanceof Dividend;
        }

        public Object getValue(Object element, String property) {
            Dividend dividend = (Dividend)element;
            if ("ex-date".equals(property)) {
                return dividend.getExDate();
            }
            if ("amount".equals(property)) {
                return dividend.getValue();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Dividend dividend = (Dividend)(element instanceof Dividend ? element : ((TableItem)element).getData());
            if ("ex-date".equals(property)) {
                dividend.setExDate((Date)value);
            } else if ("amount".equals(property)) {
                dividend.setValue(((Double)value).doubleValue());
            }
            DividendsProperties.this.viewer.update((Object)dividend, null);
        }
    }

    class DividendLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DividendLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IDividend dividend = (IDividend)element;
            switch (columnIndex) {
                case 0: {
                    return DividendsProperties.this.dateFormat.format(dividend.getExDate());
                }
                case 1: {
                    return DividendsProperties.this.numberFormat.format(dividend.getValue());
                }
            }
            return "";
        }
    }
}

