/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.IStock;
import org.eclipsetrader.core.instruments.Security;
import org.eclipsetrader.core.instruments.Stock;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.properties.Messages;

public class GeneralProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text name;
    private ComboViewer repository;
    private ComboViewer currency;
    private IRepository targetRepository;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GeneralProperties.this.setValid(GeneralProperties.this.isValid());
        }
    };

    public GeneralProperties() {
        this.setTitle(Messages.GeneralProperties_General);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_SecurityName);
        this.name = new Text(content, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        IStock stock = (IStock)this.getElement().getAdapter(IStock.class);
        if (stock != null) {
            label = new Label(content, 0);
            label.setText(Messages.GeneralProperties_Currency);
            this.currency = new ComboViewer(content, 8);
            this.currency.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    Currency c = (Currency)element;
                    return c.getCurrencyCode();
                }
            });
            this.currency.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.currency.setSorter(new ViewerSorter());
            this.currency.setInput(this.getAvailableCurrencies());
        }
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_TargetRepository);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label.setEnabled(false);
        this.repository = new ComboViewer(content, 8);
        this.repository.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.repository.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.repository.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repository.setSorter(new ViewerSorter());
        IRepository[] repositories = this.getRepositoryService().getRepositories();
        this.repository.setInput((Object)repositories);
        this.repository.getControl().setEnabled(repositories.length > 1);
        this.performDefaults();
        this.name.addModifyListener(this.modifyListener);
        return content;
    }

    protected void performDefaults() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        this.name.setText(security.getName());
        IStock stock = (IStock)this.getElement().getAdapter(IStock.class);
        if (stock != null) {
            this.currency.setSelection((ISelection)(stock.getCurrency() != null ? new StructuredSelection((Object)stock.getCurrency()) : StructuredSelection.EMPTY));
        }
        IStoreObject storeObject = (IStoreObject)security.getAdapter(IStoreObject.class);
        this.repository.setSelection((ISelection)new StructuredSelection((Object)storeObject.getStore().getRepository()));
        super.performDefaults();
    }

    protected void applyChanges() {
        Stock stock;
        Security security = (Security)this.getElement().getAdapter(Security.class);
        if (security != null) {
            security.setName(this.name.getText());
        }
        if ((stock = (Stock)this.getElement().getAdapter(Stock.class)) != null) {
            IStructuredSelection selection = (IStructuredSelection)this.currency.getSelection();
            stock.setCurrency(selection.isEmpty() ? null : (Currency)selection.getFirstElement());
        }
        this.targetRepository = (IRepository)((IStructuredSelection)this.repository.getSelection()).getFirstElement();
    }

    public boolean isValid() {
        if (this.name.getText().equals("")) {
            this.setErrorMessage(Messages.GeneralProperties_SecurityMustHaveName);
            return false;
        }
        ISecurity security = this.getRepositoryService().getSecurityFromName(this.name.getText());
        if (security != null && security != this.getElement().getAdapter(ISecurity.class)) {
            this.setErrorMessage(Messages.GeneralProperties_SameNamePrompt);
            return false;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        final ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        final IRepositoryService service = this.getRepositoryService();
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                service.runInService(new IRepositoryRunnable(){

                    public IStatus run(IProgressMonitor monitor) throws Exception {
                        IStoreObject storeObject = (IStoreObject)security.getAdapter(IStoreObject.class);
                        if (GeneralProperties.this.targetRepository != storeObject.getStore().getRepository()) {
                            service.moveAdaptable(new IAdaptable[]{security}, GeneralProperties.this.targetRepository);
                        } else {
                            service.saveAdaptable(new IAdaptable[]{security});
                        }
                        return Status.OK_STATUS;
                    }
                }, null);
            }
        });
        super.performApply();
    }

    protected IRepositoryService getRepositoryService() {
        return UIActivator.getDefault().getRepositoryService();
    }

    protected Set<Currency> getAvailableCurrencies() {
        ArrayList<Locale> locale = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        Collections.sort(locale, new Comparator<Locale>(){

            @Override
            public int compare(Locale arg0, Locale arg1) {
                return arg0.getDisplayCountry().compareTo(arg1.getDisplayCountry());
            }
        });
        int i = locale.size() - 1;
        while (i >= 1) {
            if (((Locale)locale.get(i)).getDisplayCountry().equals(((Locale)locale.get(i - 1)).getDisplayCountry())) {
                locale.remove(i);
            }
            --i;
        }
        HashSet<Currency> result = new HashSet<Currency>();
        Iterator iter = locale.iterator();
        while (iter.hasNext()) {
            try {
                Currency c = Currency.getInstance((Locale)iter.next());
                if (c == null) {
                    iter.remove();
                    continue;
                }
                result.add(c);
            }
            catch (Exception exception) {
                iter.remove();
            }
        }
        return result;
    }

    public IRepository getRepository() {
        return this.targetRepository;
    }
}

