/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipsetrader.core.feed.FeedIdentifier;
import org.eclipsetrader.core.feed.FeedProperties;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.FeedPropertiesControl;
import org.eclipsetrader.ui.internal.securities.wizards.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class IdentifierPage
extends WizardPage {
    private Text name;
    private Label propertiesLabel;
    private FeedPropertiesControl properties;
    private IFeedIdentifier feedIdentifier;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            IdentifierPage.this.updateSymbolSelection();
            if (IdentifierPage.this.isCurrentPage()) {
                IdentifierPage.this.getContainer().updateButtons();
            }
        }
    };

    public IdentifierPage() {
        super("identifier", Messages.IdentifierPage_Identifier, null);
        this.setDescription(Messages.IdentifierPage_AssignFeedIdentifier);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)content);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.IdentifierPage_IdentifierName);
        this.name = new Text(content, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.name.addModifyListener(this.modifyListener);
        this.propertiesLabel = new Label(content, 0);
        this.propertiesLabel.setText(Messages.IdentifierPage_Properties);
        this.propertiesLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.properties = new FeedPropertiesControl(content);
        this.properties.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)this.properties.getControl().getLayoutData()).heightHint = this.properties.getTree().getItemHeight() * 15;
        this.updateSymbolSelection();
    }

    public void setVisible(boolean visible) {
        this.name.setFocus();
        super.setVisible(visible);
    }

    protected IMarket[] getMarkets() {
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMarketService.class.getName());
        if (serviceReference != null) {
            IMarketService marketService = (IMarketService)context.getService(serviceReference);
            return marketService.getMarkets();
        }
        return new IMarket[0];
    }

    public boolean isPageComplete() {
        return true;
    }

    protected void updateSymbolSelection() {
        this.feedIdentifier = this.getFeedIdentifierFromSymbol(this.name.getText());
        if (this.feedIdentifier != null) {
            this.properties.setProperties((FeedProperties)this.feedIdentifier.getAdapter(FeedProperties.class));
        } else {
            this.properties.setProperties(null);
        }
        boolean hasIdentifier = !this.name.getText().equals("");
        this.propertiesLabel.setEnabled(hasIdentifier);
        this.properties.getTree().setEnabled(hasIdentifier);
    }

    protected IFeedIdentifier getFeedIdentifierFromSymbol(String s) {
        return UIActivator.getDefault().getRepositoryService().getFeedIdentifierFromSymbol(s);
    }

    public IFeedIdentifier getFeedIdentifier() {
        if (!this.name.getText().equals("")) {
            if (this.feedIdentifier == null) {
                this.feedIdentifier = new FeedIdentifier(this.name.getText(), new FeedProperties());
            }
            FeedProperties feedProperties = this.properties.getProperties();
            if (this.feedIdentifier instanceof FeedIdentifier) {
                ((FeedIdentifier)this.feedIdentifier).setProperties(feedProperties);
            }
        }
        return this.feedIdentifier;
    }
}

