/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.wizards;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.wizards.Messages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MarketsPage
extends WizardPage {
    private CheckboxTableViewer markets;

    public MarketsPage() {
        super("markets", Messages.MarketsPage_Markets, null);
        this.setDescription(Messages.MarketsPage_AssignMarkets);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)content);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.MarketsPage_Markets2);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.markets = CheckboxTableViewer.newCheckList((Composite)content, (int)2820);
        this.markets.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)this.markets.getControl().getLayoutData()).heightHint = this.markets.getTable().getItemHeight() * 4 + this.markets.getTable().getBorderWidth() * 2;
        this.markets.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.markets.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.markets.setSorter(new ViewerSorter());
        this.markets.setInput((Object)this.getMarkets());
        this.markets.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    Object[] elements = MarketsPage.this.markets.getCheckedElements();
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i] != event.getElement()) {
                            MarketsPage.this.markets.setChecked(elements[i], false);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    protected IMarket[] getMarkets() {
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMarketService.class.getName());
        if (serviceReference != null) {
            IMarketService marketService = (IMarketService)context.getService(serviceReference);
            return marketService.getMarkets();
        }
        return new IMarket[0];
    }

    public boolean isPageComplete() {
        return true;
    }

    public IMarket[] getSelectedMarkets() {
        Object[] checkedElements = this.markets.getCheckedElements();
        IMarket[] selectedMarkets = new IMarket[checkedElements.length];
        System.arraycopy(checkedElements, 0, selectedMarkets, 0, checkedElements.length);
        return selectedMarkets;
    }
}

