/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.wizards.Messages;

public class NamePage
extends WizardPage {
    private Text name;
    private ComboViewer currency;
    private ComboViewer repository;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (NamePage.this.isCurrentPage()) {
                NamePage.this.getContainer().updateButtons();
            }
        }
    };

    public NamePage() {
        super("name", Messages.NamePage_CommonStock, null);
        this.setDescription(Messages.NamePage_CreateNewCommonStock);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)content);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.NamePage_SecurityName);
        this.name = new Text(content, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.name.addModifyListener(this.modifyListener);
        this.name.setFocus();
        label = new Label(content, 0);
        label.setText(Messages.NamePage_Currency);
        this.currency = new ComboViewer(content, 8);
        this.currency.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Locale locale = (Locale)element;
                return NLS.bind((String)"{0} ({1})", (Object[])new Object[]{locale.getDisplayCountry(), Currency.getInstance(locale).getCurrencyCode()});
            }
        });
        this.currency.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.currency.setSorter(new ViewerSorter());
        this.currency.setInput(this.getAvailableCurrencies());
        this.currency.setSelection((ISelection)new StructuredSelection((Object)Locale.getDefault()));
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        label = new Label(content, 0);
        label.setText(Messages.NamePage_TargetRepository);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.repository = new ComboViewer(content, 8);
        this.repository.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.repository.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.repository.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repository.setSorter(new ViewerSorter());
        this.repository.setInput((Object)this.getRepositoryService().getRepositories());
        this.repository.setSelection((ISelection)new StructuredSelection((Object)this.getRepositoryService().getRepository("local")));
    }

    public void setVisible(boolean visible) {
        this.name.setFocus();
        super.setVisible(visible);
    }

    protected IRepositoryService getRepositoryService() {
        return UIActivator.getDefault().getRepositoryService();
    }

    public boolean isPageComplete() {
        if (this.name.getText().equals("")) {
            return false;
        }
        if (this.getRepositoryService().getSecurityFromName(this.name.getText()) != null) {
            this.setErrorMessage(Messages.NamePage_SameNamePrompt);
            return false;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return true;
    }

    public String getSecurityName() {
        return this.name.getText();
    }

    public IRepository getRepository() {
        return (IRepository)((IStructuredSelection)this.repository.getSelection()).getFirstElement();
    }

    public Currency getCurrency() {
        Locale locale = (Locale)((IStructuredSelection)this.currency.getSelection()).getFirstElement();
        return Currency.getInstance(locale);
    }

    protected List<Locale> getAvailableCurrencies() {
        ArrayList<Locale> locale = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        Collections.sort(locale, new Comparator<Locale>(){

            @Override
            public int compare(Locale arg0, Locale arg1) {
                return arg0.getDisplayCountry().compareTo(arg1.getDisplayCountry());
            }
        });
        int i = locale.size() - 1;
        while (i >= 1) {
            if (((Locale)locale.get(i)).getDisplayCountry().equals(((Locale)locale.get(i - 1)).getDisplayCountry())) {
                locale.remove(i);
            }
            --i;
        }
        Iterator iter = locale.iterator();
        while (iter.hasNext()) {
            try {
                if (Currency.getInstance((Locale)iter.next()) != null) continue;
                iter.remove();
            }
            catch (Exception exception) {
                iter.remove();
            }
        }
        return locale;
    }
}

