/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.securities.wizards;

import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.Stock;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryRunnable;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.securities.wizards.IdentifierPage;
import org.eclipsetrader.ui.internal.securities.wizards.MarketsPage;
import org.eclipsetrader.ui.internal.securities.wizards.Messages;
import org.eclipsetrader.ui.internal.securities.wizards.NamePage;

public class SecurityWizard
extends Wizard
implements INewWizard {
    private Image image;
    private NamePage namePage;
    private IdentifierPage identifierPage;
    private MarketsPage marketsPage;

    public SecurityWizard() {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)UIActivator.getDefault().getBundle().getResource("icons/wizban/newfile_wiz.gif"));
        this.image = descriptor.createImage();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }

    public String getWindowTitle() {
        return Messages.SecurityWizard_NewCommonStock;
    }

    public Image getDefaultPageImage() {
        return this.image;
    }

    public void addPages() {
        this.namePage = new NamePage();
        this.addPage((IWizardPage)this.namePage);
        this.identifierPage = new IdentifierPage();
        this.addPage((IWizardPage)this.identifierPage);
        this.marketsPage = new MarketsPage();
        this.addPage((IWizardPage)this.marketsPage);
    }

    public boolean performFinish() {
        final IRepository repository = this.namePage.getRepository();
        final Stock resource = new Stock(this.namePage.getSecurityName(), this.identifierPage.getFeedIdentifier(), this.namePage.getCurrency());
        final IMarket[] markets = this.marketsPage.getSelectedMarkets();
        final IRepositoryService service = UIActivator.getDefault().getRepositoryService();
        service.runInService(new IRepositoryRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                service.moveAdaptable(new IAdaptable[]{resource}, repository);
                int i = 0;
                while (i < markets.length) {
                    markets[i].addMembers(new ISecurity[]{resource});
                    ++i;
                }
                return Status.OK_STATUS;
            }
        }, null);
        return true;
    }
}

