/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.trading.IAlert;
import org.eclipsetrader.core.trading.IAlertService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.AlertLabelProvider;
import org.eclipsetrader.ui.internal.trading.Messages;
import org.eclipsetrader.ui.internal.trading.NewAlertWizard;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AlertPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    TableViewer viewer;
    Button add;
    Button delete;
    CTabFolder folder;
    IAlertService alertService;
    List<IAlert> list;
    PropertyPage[] propertyPages = new PropertyPage[0];
    ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AlertPropertyPage.this.delete.setEnabled(!event.getSelection().isEmpty());
            AlertPropertyPage.this.doSelectionChanged((IStructuredSelection)event.getSelection());
        }
    };

    public AlertPropertyPage() {
        this(UIActivator.getDefault().getBundle().getBundleContext());
    }

    protected AlertPropertyPage(BundleContext context) {
        this.setTitle(Messages.AlertPropertyPage_Title);
        ServiceReference serviceReference = context.getServiceReference(IAlertService.class.getName());
        if (serviceReference != null) {
            this.alertService = (IAlertService)context.getService(serviceReference);
            context.ungetService(serviceReference);
        }
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.viewer = new TableViewer(content, 67588);
        this.viewer.getTable().setHeaderVisible(false);
        this.viewer.getTable().setLinesVisible(false);
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.heightHint = this.viewer.getTable().getItemHeight() * 5 + this.viewer.getTable().getBorderWidth() * 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AlertLabelProvider());
        this.viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.createButtonsBar(content);
        this.folder = new CTabFolder(content, 2176);
        this.folder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.performDefaults();
        return content;
    }

    protected void createButtonsBar(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 128, false, false));
        this.add = new Button(content, 0);
        this.add.setImage(this.getImageRegistry().get("alert_add_image"));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlertPropertyPage.this.doAddNewAlert();
            }
        });
        this.delete = new Button(content, 0);
        this.delete.setImage(this.getImageRegistry().get("alert_delete_image"));
        this.delete.setEnabled(false);
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)AlertPropertyPage.this.viewer.getSelection();
                AlertPropertyPage.this.list.removeAll(selection.toList());
                AlertPropertyPage.this.viewer.refresh();
            }
        });
    }

    ImageRegistry getImageRegistry() {
        return UIActivator.getDefault().getImageRegistry();
    }

    protected void performDefaults() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        IAlert[] alerts = this.alertService.getAlerts(security);
        this.list = new ArrayList<IAlert>(Arrays.asList(alerts));
        this.viewer.setInput(this.list);
    }

    void doSelectionChanged(IStructuredSelection selection) {
        int i = 0;
        while (i < this.propertyPages.length) {
            this.propertyPages[i].dispose();
            ++i;
        }
        if (selection.isEmpty()) {
            this.propertyPages = new PropertyPage[0];
            this.createTabbedPages();
            return;
        }
        final Object element = selection.getFirstElement();
        PropertyPageManager pageManager = new PropertyPageManager();
        PropertyPageContributorManager.getManager().contribute(pageManager, element);
        IAdaptable adaptableElement = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter.isAssignableFrom(element.getClass())) {
                    return element;
                }
                return null;
            }
        };
        ArrayList<PropertyPage> list = new ArrayList<PropertyPage>();
        for (Object nodeObj : pageManager.getElements(0)) {
            IPreferenceNode node = (IPreferenceNode)nodeObj;
            node.createPage();
            if (!(node.getPage() instanceof PropertyPage)) continue;
            PropertyPage page = (PropertyPage)node.getPage();
            page.setElement(adaptableElement);
            list.add(page);
        }
        this.propertyPages = list.toArray(new PropertyPage[list.size()]);
        this.createTabbedPages();
    }

    void createTabbedPages() {
        CTabItem[] existingItems = this.folder.getItems();
        int i = 0;
        while (i < existingItems.length) {
            existingItems[i].dispose();
            ++i;
        }
        if (this.propertyPages != null) {
            i = 0;
            while (i < this.propertyPages.length) {
                this.propertyPages[i].dispose();
                ++i;
            }
        }
        i = 0;
        while (i < this.propertyPages.length) {
            CTabItem tabItem = new CTabItem(this.folder, 0);
            Composite content = new Composite((Composite)this.folder, 0);
            FillLayout layout = new FillLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            content.setLayout((Layout)layout);
            this.propertyPages[i].createControl(content);
            tabItem.setText(this.propertyPages[i].getTitle());
            tabItem.setControl((Control)content);
            ++i;
        }
        if (this.folder.getItemCount() != 0) {
            this.folder.setSelection(this.folder.getItem(0));
        }
        this.folder.getParent().layout();
    }

    protected void performApply() {
        super.performApply();
        this.viewer.refresh();
    }

    public boolean performOk() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        if (this.isControlCreated()) {
            int i = 0;
            while (i < this.propertyPages.length) {
                this.propertyPages[i].performOk();
                ++i;
            }
            this.alertService.setAlerts(security, this.list.toArray(new IAlert[this.list.size()]));
        }
        return super.performOk();
    }

    void doAddNewAlert() {
        ISecurity security = (ISecurity)this.getElement().getAdapter(ISecurity.class);
        NewAlertWizard wizard = new NewAlertWizard(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)security));
        WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dlg.open() == 0) {
            this.performDefaults();
        }
    }
}

