/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class ProxySelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private ISelectionProvider selectionProvider;
    private ListenerList listeners = new ListenerList(1);

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.selectionProvider = selectionProvider;
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
        }
    }

    public void dispose() {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.listeners.clear();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.selectionProvider != null ? this.selectionProvider.getSelection() : null;
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((ISelectionChangedListener)l[i]).selectionChanged(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

