/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.trading.TargetPrice;
import org.eclipsetrader.core.trading.IAlert;
import org.eclipsetrader.core.trading.IAlertService;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.Messages;
import org.eclipsetrader.ui.internal.trading.TargetPriceWizardPage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TargetPriceWizard
extends Wizard
implements INewWizard {
    private TargetPriceWizardPage page;
    private ISecurity security;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            throw new IllegalStateException("Nothing selected");
        }
        Object o = selection.getFirstElement();
        if (o instanceof IAdaptable) {
            o = ((IAdaptable)o).getAdapter(ISecurity.class);
        }
        if (o == null || !(o instanceof ISecurity)) {
            throw new IllegalStateException("Not a security");
        }
        this.security = (ISecurity)o;
    }

    public String getWindowTitle() {
        return Messages.TargetPriceWizard_WindowTitle;
    }

    public Image getDefaultPageImage() {
        return UIActivator.getDefault().getImageRegistry().get("alert_wizard_image");
    }

    public void addPages() {
        this.page = new TargetPriceWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IAlertService service = this.getAlertService();
        ArrayList<IAlert> list = new ArrayList<IAlert>(Arrays.asList(service.getAlerts(this.security)));
        TargetPrice alert = new TargetPrice();
        alert.setParameters(this.page.getParametersMap());
        list.add((IAlert)alert);
        service.setAlerts(this.security, list.toArray(new IAlert[list.size()]));
        return true;
    }

    IAlertService getAlertService() {
        IAlertService service = null;
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IAlertService.class.getName());
        if (serviceReference != null) {
            service = (IAlertService)context.getService(serviceReference);
            context.ungetService(serviceReference);
        }
        return service;
    }
}

