/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.ui.internal.trading.portfolio.PositionElement;

public class AccountElement
extends PlatformObject
implements IViewItem,
IWorkbenchAdapter {
    IViewItem parent;
    IAccount account;
    List<PositionElement> childs;

    public AccountElement(IViewItem parent, IAccount account) {
        this.parent = parent;
        this.account = account;
        this.childs = new ArrayList<PositionElement>();
        IPosition[] iPositionArray = account.getPositions();
        int n = iPositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPosition position = iPositionArray[n2];
            this.childs.add(new PositionElement(this, position));
            ++n2;
        }
    }

    public void accept(IViewItemVisitor visitor) {
        if (visitor.visit((IViewItem)this)) {
            for (PositionElement element : this.childs) {
                element.accept(visitor);
            }
        }
    }

    public int getItemCount() {
        return this.childs.size();
    }

    public IViewItem[] getItems() {
        return this.childs.toArray(new IViewItem[this.childs.size()]);
    }

    public IViewItem getParent() {
        return this.parent;
    }

    public IAdaptable[] getValues() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        IBroker broker;
        if (adapter.isAssignableFrom(this.account.getClass())) {
            return this.account;
        }
        if (adapter.isAssignableFrom(IBroker.class) && (broker = (IBroker)this.parent.getAdapter(IBroker.class)) != null) {
            return broker;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccountElement)) {
            return false;
        }
        return this.account.equals(((AccountElement)((Object)obj)).account);
    }

    public int hashCode() {
        return 11 * this.account.hashCode();
    }

    public Object[] getChildren(Object o) {
        return this.childs.toArray(new IViewItem[this.childs.size()]);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.account.getDescription();
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public String toString() {
        return this.account.getDescription();
    }
}

