/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.ui.internal.trading.portfolio.BrokerElement;
import org.eclipsetrader.ui.internal.trading.portfolio.GainViewItemVisitor;

public class GainLabelProvider
extends CellLabelProvider {
    private NumberFormat formatter = NumberFormat.getInstance();
    private NumberFormat percentageFormatter = NumberFormat.getInstance();
    private Color positiveColor = Display.getDefault().getSystemColor(5);
    private Color negativeColor = Display.getDefault().getSystemColor(3);
    private Font font;

    public GainLabelProvider() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(2);
        this.percentageFormatter.setGroupingUsed(true);
        this.percentageFormatter.setMinimumIntegerDigits(1);
        this.percentageFormatter.setMinimumFractionDigits(2);
        this.percentageFormatter.setMaximumFractionDigits(2);
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        if (this.font == null) {
            Display display = viewer.getControl().getDisplay();
            FontData[] fontData = display.getSystemFont().getFontData();
            this.font = new Font((Device)display, fontData[0].getName(), fontData[0].getHeight(), 1);
        }
        super.initialize(viewer, column);
    }

    public void update(ViewerCell cell) {
        if (!(cell.getElement() instanceof IViewItem)) {
            return;
        }
        GainViewItemVisitor visitor = new GainViewItemVisitor();
        ((IViewItem)cell.getElement()).accept((IViewItemVisitor)visitor);
        double value = visitor.getValue();
        double percentage = visitor.getPercentage();
        cell.setText(String.valueOf(value > 0.0 ? "+" : "") + this.formatter.format(value) + " (" + (value > 0.0 ? "+" : "") + this.percentageFormatter.format(percentage) + "%)");
        cell.setForeground(value != 0.0 ? (value > 0.0 ? this.positiveColor : this.negativeColor) : null);
        if (cell.getElement() instanceof BrokerElement) {
            cell.setFont(this.font);
        }
    }

    public void dispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        super.dispose();
    }
}

