/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;

public class GainViewItemVisitor
implements IViewItemVisitor {
    double purchaseValue = 0.0;
    double marketValue = 0.0;
    double value = 0.0;
    double percentage = 0.0;

    public boolean visit(IViewItem viewItem) {
        IPosition position = (IPosition)viewItem.getAdapter(IPosition.class);
        ITrade trade = (ITrade)viewItem.getAdapter(ITrade.class);
        if (position != null && trade != null && trade.getPrice() != null) {
            this.purchaseValue += (double)position.getQuantity().longValue() * position.getPrice();
            this.marketValue += (double)position.getQuantity().longValue() * trade.getPrice();
            this.value = this.marketValue - this.purchaseValue;
            this.percentage = this.value / this.purchaseValue * 100.0;
        }
        return true;
    }

    public double getValue() {
        return this.value;
    }

    public double getPercentage() {
        return this.percentage;
    }
}

