/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IPositionListener;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.core.trading.PositionEvent;
import org.eclipsetrader.core.views.IView;
import org.eclipsetrader.core.views.IViewChangeListener;
import org.eclipsetrader.core.views.IViewItem;
import org.eclipsetrader.core.views.IViewItemVisitor;
import org.eclipsetrader.core.views.IViewVisitor;
import org.eclipsetrader.core.views.ViewEvent;
import org.eclipsetrader.core.views.ViewItemDelta;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.portfolio.BrokerElement;
import org.eclipsetrader.ui.internal.trading.portfolio.PositionElement;

public class PortfolioView
extends PlatformObject
implements IView {
    ITradingService tradingService;
    IMarketService marketService;
    IBroker[] broker;
    List<BrokerElement> items;
    MarketPricingEnvironment pricingEnvironment;
    ListenerList listeners = new ListenerList(1);
    IPositionListener positionListener = new IPositionListener(){

        public void positionChanged(PositionEvent e) {
            PortfolioView.this.updateView();
        }

        public void positionClosed(PositionEvent e) {
            PortfolioView.this.updateView();
        }

        public void positionOpened(PositionEvent e) {
            PortfolioView.this.updateView();
        }
    };

    public PortfolioView() {
        this.items = new ArrayList<BrokerElement>();
    }

    public PortfolioView(ITradingService tradingService, IMarketService marketService) {
        this.tradingService = tradingService;
        this.marketService = marketService;
        this.broker = tradingService.getBrokers();
        this.items = new ArrayList<BrokerElement>();
        int i = 0;
        while (i < this.broker.length) {
            this.items.add(new BrokerElement(this.broker[i]));
            ++i;
        }
        final HashSet list = new HashSet();
        this.accept(new IViewVisitor(){

            public boolean visit(IView view) {
                return true;
            }

            public boolean visit(IViewItem viewItem) {
                ISecurity security;
                IAccount account = (IAccount)viewItem.getAdapter(IAccount.class);
                if (account != null) {
                    account.addPositionListener(PortfolioView.this.positionListener);
                }
                if ((security = (ISecurity)viewItem.getAdapter(ISecurity.class)) != null && !list.contains(security)) {
                    list.add(security);
                }
                return true;
            }
        });
        this.pricingEnvironment = new MarketPricingEnvironment(marketService);
        this.pricingEnvironment.addSecurities(list.toArray(new ISecurity[list.size()]));
        this.pricingEnvironment.addPricingListener(new IPricingListener(){

            public void pricingUpdate(PricingEvent event) {
                PortfolioView.this.doPricingUpdate(event);
            }
        });
        this.accept(new IViewVisitor(){

            public boolean visit(IView view) {
                return true;
            }

            public boolean visit(IViewItem viewItem) {
                ITrade trade;
                PositionElement element = (PositionElement)((Object)viewItem.getAdapter(PositionElement.class));
                ISecurity security = (ISecurity)viewItem.getAdapter(ISecurity.class);
                if (element != null && security != null && (trade = PortfolioView.this.pricingEnvironment.getTrade(security)) != null) {
                    element.setTrade(trade);
                }
                return true;
            }
        });
    }

    protected void doPricingUpdate(final PricingEvent event) {
        final HashSet viewDelta = new HashSet();
        this.accept(new IViewVisitor(){

            public boolean visit(IView view) {
                return true;
            }

            public boolean visit(IViewItem viewItem) {
                ISecurity security = (ISecurity)viewItem.getAdapter(ISecurity.class);
                if (security == null || !event.getSecurity().equals(security)) {
                    return true;
                }
                PositionElement element = (PositionElement)((Object)viewItem.getAdapter(PositionElement.class));
                if (element != null) {
                    PricingDelta[] pricingDeltaArray = event.getDelta();
                    int n = pricingDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PricingDelta delta = pricingDeltaArray[n2];
                        if (delta.getNewValue() instanceof ITrade) {
                            element.setTrade((ITrade)delta.getNewValue());
                            viewDelta.add(new ViewItemDelta(4, viewItem));
                        }
                        ++n2;
                    }
                }
                return true;
            }
        });
        if (viewDelta.size() != 0) {
            this.fireViewChangedEvent(viewDelta.toArray(new ViewItemDelta[viewDelta.size()]));
        }
    }

    void updateView() {
        this.accept(new IViewVisitor(){

            public boolean visit(IView view) {
                return true;
            }

            public boolean visit(IViewItem viewItem) {
                IAccount account = (IAccount)viewItem.getAdapter(IAccount.class);
                if (account != null) {
                    account.removePositionListener(PortfolioView.this.positionListener);
                }
                return true;
            }
        });
        ArrayList<BrokerElement> items = new ArrayList<BrokerElement>();
        int i = 0;
        while (i < this.broker.length) {
            items.add(new BrokerElement(this.broker[i]));
            ++i;
        }
        this.items = items;
        final HashSet list = new HashSet();
        this.accept(new IViewVisitor(){

            public boolean visit(IView view) {
                return true;
            }

            public boolean visit(IViewItem viewItem) {
                ISecurity security;
                IAccount account = (IAccount)viewItem.getAdapter(IAccount.class);
                if (account != null) {
                    account.addPositionListener(PortfolioView.this.positionListener);
                }
                if ((security = (ISecurity)viewItem.getAdapter(ISecurity.class)) != null && !list.contains(security)) {
                    list.add(security);
                }
                return true;
            }
        });
        this.pricingEnvironment.addSecurities(list.toArray(new ISecurity[list.size()]));
        this.accept(new IViewVisitor(){

            public boolean visit(IView view) {
                return true;
            }

            public boolean visit(IViewItem viewItem) {
                ITrade trade;
                PositionElement element = (PositionElement)((Object)viewItem.getAdapter(PositionElement.class));
                ISecurity security = (ISecurity)viewItem.getAdapter(ISecurity.class);
                if (element != null && security != null && (trade = PortfolioView.this.pricingEnvironment.getTrade(security)) != null) {
                    element.setTrade(trade);
                }
                return true;
            }
        });
        this.fireViewChangedEvent(new ViewItemDelta[0]);
    }

    protected void fireViewChangedEvent(ViewItemDelta[] delta) {
        ViewEvent e = new ViewEvent((IView)this, delta);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IViewChangeListener)l[i]).viewChanged(e);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.ui", 0, "Error notifiying listeners", t);
                UIActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    public void accept(IViewVisitor visitor) {
        if (visitor.visit((IView)this)) {
            for (IViewItem iViewItem : this.items) {
                iViewItem.accept((IViewItemVisitor)visitor);
            }
        }
    }

    public void addViewChangeListener(IViewChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        this.listeners.clear();
        if (this.pricingEnvironment != null) {
            this.pricingEnvironment.dispose();
        }
    }

    public IViewItem[] getItems() {
        return this.items.toArray(new IViewItem[this.items.size()]);
    }

    public void removeViewChangeListener(IViewChangeListener listener) {
        this.listeners.remove((Object)listener);
    }
}

