/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.ui.SelectionProvider;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.trading.portfolio.ElementLabelProvider;
import org.eclipsetrader.ui.internal.trading.portfolio.GainLabelProvider;
import org.eclipsetrader.ui.internal.trading.portfolio.Messages;
import org.eclipsetrader.ui.internal.trading.portfolio.PortfolioContentProvider;
import org.eclipsetrader.ui.internal.trading.portfolio.PortfolioView;
import org.eclipsetrader.ui.internal.trading.portfolio.PositionLabelProvider;
import org.eclipsetrader.ui.internal.trading.portfolio.PriceLabelProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PortfolioViewPart
extends ViewPart {
    TreeViewer viewer;
    PortfolioView view;
    BundleContext context;
    ServiceReference tradingServiceReference;
    ITradingService tradingService;
    ServiceReference marketServiceReference;
    IMarketService marketService;
    Action expandAllAction;
    Action collapseAllAction;
    Action refreshAllAction;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.context = UIActivator.getDefault().getBundle().getBundleContext();
        this.tradingServiceReference = this.context.getServiceReference(ITradingService.class.getName());
        this.tradingService = (ITradingService)this.context.getService(this.tradingServiceReference);
        this.marketServiceReference = this.context.getServiceReference(IMarketService.class.getName());
        this.marketService = (IMarketService)this.context.getService(this.marketServiceReference);
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
        site.getActionBars().setGlobalActionHandler("properties", (IAction)new PropertyDialogAction((IShellProvider)site, site.getSelectionProvider()));
        this.initializeActions();
        IToolBarManager toolbarManager = site.getActionBars().getToolBarManager();
        toolbarManager.add((IContributionItem)new Separator("group.new"));
        toolbarManager.add((IContributionItem)new GroupMarker("group.goto"));
        toolbarManager.add((IContributionItem)new Separator("group.open"));
        toolbarManager.add((IContributionItem)new GroupMarker("group.openWith"));
        toolbarManager.add((IContributionItem)new Separator("group.show"));
        toolbarManager.add((IAction)this.expandAllAction);
        toolbarManager.add((IAction)this.collapseAllAction);
        toolbarManager.add((IContributionItem)new Separator("group.edit"));
        toolbarManager.add((IContributionItem)new GroupMarker("group.reorganize"));
        toolbarManager.add((IContributionItem)new GroupMarker("group.port"));
        toolbarManager.add((IContributionItem)new Separator("group.generate"));
        toolbarManager.add((IContributionItem)new Separator("group.search"));
        toolbarManager.add((IContributionItem)new Separator("group.build"));
        toolbarManager.add((IContributionItem)new Separator("additions"));
        toolbarManager.add((IContributionItem)new Separator("group.properties"));
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("group.new"));
        menuManager.add((IContributionItem)new GroupMarker("group.goto"));
        menuManager.add((IContributionItem)new Separator("group.open"));
        menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
        menuManager.add((IContributionItem)new Separator("group.show"));
        menuManager.add((IContributionItem)new Separator("group.edit"));
        menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
        menuManager.add((IContributionItem)new GroupMarker("group.port"));
        menuManager.add((IContributionItem)new Separator("group.generate"));
        menuManager.add((IContributionItem)new Separator("group.search"));
        menuManager.add((IContributionItem)new Separator("group.build"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("group.properties"));
        site.getActionBars().updateActionBars();
    }

    void initializeActions() {
        ImageRegistry imageRegistry = UIActivator.getDefault().getImageRegistry();
        this.collapseAllAction = new Action(Messages.PortfolioViewPart_CollapseAll, imageRegistry.getDescriptor("collapseall")){

            public void run() {
                PortfolioViewPart.this.viewer.collapseAll();
            }
        };
        this.expandAllAction = new Action(Messages.PortfolioViewPart_ExpandAll, imageRegistry.getDescriptor("expandall")){

            public void run() {
                PortfolioViewPart.this.viewer.expandAll();
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.createContextMenu();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PortfolioViewPart.this.getViewSite().getSelectionProvider().setSelection(event.getSelection());
            }
        });
        this.updateView();
    }

    protected void createViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 65538);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(false);
        this.viewer.setContentProvider((IContentProvider)new PortfolioContentProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)new PortfolioView());
        GC gc = new GC((Drawable)parent);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)40));
        viewerColumn.setLabelProvider((CellLabelProvider)new ElementLabelProvider());
        viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.PortfolioViewPart_Position);
        viewerColumn.getColumn().setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)15));
        viewerColumn.setLabelProvider((CellLabelProvider)new PositionLabelProvider());
        viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.PortfolioViewPart_Price);
        viewerColumn.getColumn().setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)15));
        viewerColumn.setLabelProvider((CellLabelProvider)new PriceLabelProvider());
        viewerColumn = new TreeViewerColumn(this.viewer, 131072);
        viewerColumn.getColumn().setText(Messages.PortfolioViewPart_PL);
        viewerColumn.getColumn().setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)30));
        viewerColumn.setLabelProvider((CellLabelProvider)new GainLabelProvider());
    }

    protected void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("group.new"));
                menuManager.add((IContributionItem)new GroupMarker("group.goto"));
                menuManager.add((IContributionItem)new Separator("group.open"));
                menuManager.add((IContributionItem)new GroupMarker("group.openWith"));
                menuManager.add((IContributionItem)new Separator("group.trade"));
                menuManager.add((IContributionItem)new GroupMarker("group.tradeWith"));
                menuManager.add((IContributionItem)new Separator("group.show"));
                menuManager.add((IContributionItem)new Separator("group.edit"));
                menuManager.add((IContributionItem)new GroupMarker("group.reorganize"));
                menuManager.add((IContributionItem)new GroupMarker("group.port"));
                menuManager.add((IContributionItem)new Separator("group.generate"));
                menuManager.add((IContributionItem)new Separator("group.search"));
                menuManager.add((IContributionItem)new Separator("group.build"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("group.properties"));
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    protected void updateView() {
        Job job = new Job(Messages.PortfolioViewPart_LoadingPortfolio){

            protected IStatus run(IProgressMonitor monitor) {
                PortfolioViewPart.this.view = new PortfolioView(PortfolioViewPart.this.tradingService, PortfolioViewPart.this.marketService);
                return Status.OK_STATUS;
            }
        };
        final Display display = this.viewer.getControl().getDisplay();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (PortfolioViewPart.this.view != null) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).PortfolioViewPart.this.viewer.getControl().isDisposed()) {
                                (this).PortfolioViewPart.this.viewer.setInput((Object)(this).PortfolioViewPart.this.view);
                                (this).PortfolioViewPart.this.viewer.expandAll();
                            }
                        }
                    });
                }
            }
        });
        job.schedule();
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.context != null) {
            if (this.tradingServiceReference != null) {
                this.context.ungetService(this.tradingServiceReference);
            }
            if (this.marketServiceReference != null) {
                this.context.ungetService(this.marketServiceReference);
            }
        }
        super.dispose();
    }
}

