/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.ui.internal.trading.portfolio.PositionElement;

public class PositionLabelProvider
extends CellLabelProvider {
    private NumberFormat formatter = NumberFormat.getInstance();

    public PositionLabelProvider() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(0);
    }

    public void update(ViewerCell cell) {
        if (!(cell.getElement() instanceof PositionElement)) {
            return;
        }
        PositionElement element = (PositionElement)((Object)cell.getElement());
        IPosition position = (IPosition)element.getAdapter(IPosition.class);
        if (position == null) {
            return;
        }
        cell.setText(this.formatter.format(position.getQuantity()));
    }
}

