/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.trading.portfolio;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipsetrader.core.trading.IPosition;
import org.eclipsetrader.core.views.IViewItem;

public class PriceLabelProvider
extends CellLabelProvider {
    private NumberFormat formatter = NumberFormat.getInstance();

    public PriceLabelProvider() {
        this.formatter.setGroupingUsed(true);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setMinimumFractionDigits(1);
        this.formatter.setMaximumFractionDigits(4);
    }

    public void update(ViewerCell cell) {
        if (!(cell.getElement() instanceof IViewItem)) {
            return;
        }
        IPosition position = (IPosition)((IViewItem)cell.getElement()).getAdapter(IPosition.class);
        if (position == null) {
            return;
        }
        cell.setText(this.formatter.format(position.getPrice()));
    }
}

