/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class BoxItem
extends Item {
    private Canvas canvas;
    private Composite row1;
    private Composite row2;
    private Composite group;
    private Label[] columns = new Label[5];
    private Color background = Display.getDefault().getSystemColor(25);
    private Color foreground = Display.getDefault().getSystemColor(24);
    private Font boldFont;
    private Listener eventListener = new Listener(){

        public void handleEvent(Event event) {
            Point p = BoxItem.this.canvas.getParent().toControl(((Control)event.widget).toDisplay(event.x, event.y));
            event.x = p.x;
            event.y = p.y;
            event.item = BoxItem.this;
            BoxItem.this.canvas.getParent().notifyListeners(event.type, event);
        }
    };
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            e.gc.setForeground(BoxItem.this.foreground);
            Rectangle rect = BoxItem.this.canvas.getClientArea();
            e.gc.drawRectangle(0, 0, rect.width - 1, rect.height - 1);
        }
    };
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (BoxItem.this.boldFont != null) {
                BoxItem.this.boldFont.dispose();
            }
        }
    };

    public BoxItem(Composite parent, int style) {
        super((Widget)parent, style);
        FontData[] fontData = parent.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 1);
            ++i;
        }
        this.boldFont = new Font((Device)parent.getDisplay(), fontData);
        this.canvas = new Canvas(parent, style);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 3;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 2;
        this.canvas.setLayout((Layout)gridLayout);
        this.canvas.setBackground(this.background);
        this.canvas.addPaintListener(this.paintListener);
        this.canvas.addDisposeListener(this.disposeListener);
        this.canvas.setBackgroundMode(0);
        this.row1 = new Composite((Composite)this.canvas, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 0;
        this.row1.setLayout((Layout)gridLayout);
        this.row1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.row1.setBackground(this.background);
        this.columns[0] = new Label(this.row1, 0);
        this.columns[0].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.columns[0].setForeground(this.foreground);
        this.columns[0].setBackground(this.background);
        this.columns[1] = new Label(this.row1, 0);
        this.columns[1].setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.columns[1].setForeground(this.foreground);
        this.columns[1].setBackground(this.background);
        this.row2 = new Composite((Composite)this.canvas, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 0;
        this.row2.setLayout((Layout)gridLayout);
        this.row2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.row2.setBackground(this.background);
        this.columns[2] = new Label(this.row2, 0);
        this.columns[2].setFont(this.boldFont);
        this.columns[2].setForeground(this.foreground);
        this.columns[2].setBackground(this.background);
        this.group = new Composite(this.row2, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 0;
        this.group.setLayout((Layout)gridLayout);
        this.group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.group.setBackground(this.background);
        this.columns[3] = new Label(this.group, 0);
        this.columns[3].setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.columns[3].setForeground(this.foreground);
        this.columns[3].setBackground(this.background);
        this.columns[4] = new Label(this.group, 0);
        this.columns[4].setBackground(this.background);
        this.canvas.addListener(3, this.eventListener);
        this.canvas.addListener(4, this.eventListener);
        this.row1.addListener(3, this.eventListener);
        this.row1.addListener(4, this.eventListener);
        this.row2.addListener(3, this.eventListener);
        this.row2.addListener(4, this.eventListener);
        this.group.addListener(4, this.eventListener);
        this.group.addListener(3, this.eventListener);
        int i2 = 0;
        while (i2 < this.columns.length) {
            this.columns[i2].addListener(3, this.eventListener);
            this.columns[i2].addListener(4, this.eventListener);
            ++i2;
        }
    }

    public void dispose() {
        this.canvas.setMenu(null);
        this.row1.setMenu(null);
        this.row2.setMenu(null);
        this.group.setMenu(null);
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].setMenu(null);
            ++i;
        }
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        super.dispose();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setText(int index, String string) {
        this.columns[index].setText(string.replaceAll("[&]", "&&"));
    }

    public String getText(int index) {
        return this.columns[index].getText();
    }

    public Color getBackground(int index) {
        return this.columns[index].getBackground();
    }

    public void setBackground(int index, Color color) {
        this.columns[index].setBackground(color);
    }

    public Color getForeground(int index) {
        return this.columns[index].getForeground();
    }

    public void setForeground(int index, Color color) {
        this.columns[index].setForeground(color);
    }

    public Rectangle getBounds() {
        return this.canvas.getBounds();
    }

    public Rectangle getBounds(int index) {
        return this.columns[index].getBounds();
    }

    public Font getFont(int index) {
        return this.columns[index].getFont();
    }

    public void setFont(int index, Font font) {
        this.columns[index].setFont(font);
    }

    public Image getImage(int index) {
        return this.columns[index].getImage();
    }

    public void setImage(int index, Image image) {
        this.columns[index].setImage(image);
    }

    public Composite getParent() {
        return this.canvas.getParent();
    }

    public String toString() {
        return "[BoxItem] " + this.columns[0].getText();
    }

    public void setMenu(Menu menu) {
        this.canvas.setMenu(menu);
        this.row1.setMenu(menu);
        this.row2.setMenu(menu);
        this.group.setMenu(menu);
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].setMenu(menu);
            ++i;
        }
    }

    public Menu getMenu() {
        return this.canvas.getMenu();
    }
}

