/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipsetrader.ui.internal.views.BoxItem;
import org.eclipsetrader.ui.internal.views.BoxViewerRow;

public class BoxViewer
extends AbstractTableViewer {
    private Composite control;
    private List<BoxViewerRow> rows = new ArrayList<BoxViewerRow>();
    private BoxItem selection;

    public BoxViewer(Composite parent) {
        this(parent, 0);
    }

    public BoxViewer(Composite parent, int style) {
        this.control = new Composite(parent, style);
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        this.control.setLayout((Layout)layout);
        this.control.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (BoxViewer.this.selection != event.item) {
                    BoxViewer.this.selection = (BoxItem)event.item;
                    BoxViewer.this.control.notifyListeners(13, event);
                    BoxViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)BoxViewer.this, (ISelection)(BoxViewer.this.selection != null ? new StructuredSelection((Object)BoxViewer.this.selection) : StructuredSelection.EMPTY)));
                }
            }
        });
    }

    BoxItem getItem(int index) {
        return (BoxItem)this.rows.get(index).getItem();
    }

    BoxViewerRow getRow(int index) {
        return this.rows.get(index);
    }

    int getRowCount() {
        return this.rows.size();
    }

    protected void doClear(int index) {
    }

    protected void doClearAll() {
    }

    protected void doDeselectAll() {
        this.selection = null;
    }

    protected Widget doGetColumn(int index) {
        return this.control;
    }

    protected Item doGetItem(int index) {
        return (Item)this.rows.get(index).getItem();
    }

    protected int doGetItemCount() {
        return this.rows.size();
    }

    protected Item[] doGetItems() {
        Item[] items = new Item[this.rows.size()];
        int i = 0;
        while (i < this.rows.size()) {
            items[i] = (Item)this.rows.get(i).getItem();
            ++i;
        }
        return items;
    }

    protected Item[] doGetSelection() {
        Item[] itemArray;
        if (this.selection != null) {
            Item[] itemArray2 = new Item[1];
            itemArray = itemArray2;
            itemArray2[0] = this.selection;
        } else {
            itemArray = new Item[]{};
        }
        return itemArray;
    }

    protected int[] doGetSelectionIndices() {
        return new int[0];
    }

    protected int doIndexOf(Item item) {
        int i = 0;
        while (i < this.rows.size()) {
            if (this.rows.get(i).getItem() == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void doRemove(int start, int end) {
        BoxViewerRow[] r = this.rows.toArray(new BoxViewerRow[this.rows.size()]);
        int i = start;
        while (i <= end) {
            ((BoxItem)r[i].getItem()).setMenu(null);
            r[i].getItem().dispose();
            this.rows.remove((Object)r[i]);
            ++i;
        }
    }

    protected void doRemove(int[] indices) {
        BoxViewerRow[] r = this.rows.toArray(new BoxViewerRow[this.rows.size()]);
        int i = 0;
        while (i < indices.length) {
            ((BoxItem)r[indices[i]].getItem()).setMenu(null);
            r[indices[i]].getItem().dispose();
            this.rows.remove((Object)r[indices[i]]);
            ++i;
        }
    }

    protected void doRemoveAll() {
        int i = 0;
        while (i < this.rows.size()) {
            ((BoxItem)this.rows.get(i).getItem()).setMenu(null);
            this.rows.get(i).getItem().dispose();
            ++i;
        }
        this.rows.clear();
    }

    protected void doResetItem(Item item) {
    }

    protected void doSelect(int[] indices) {
    }

    protected void doSetItemCount(int count) {
        while (this.rows.size() > count) {
            BoxViewerRow row = this.rows.get(this.rows.size() - 1);
            ((BoxItem)row.getItem()).setMenu(null);
            row.getItem().dispose();
            this.rows.remove(this.rows.size() - 1);
        }
        int columns = this.doGetColumnCount();
        while (this.rows.size() < count) {
            BoxItem item = new BoxItem(this.control, 0);
            item.setMenu(this.control.getMenu());
            BoxViewerRow viewerRow = new BoxViewerRow(item, columns);
            this.rows.add(viewerRow);
        }
    }

    protected void doSetSelection(int[] indices) {
    }

    protected void doSetSelection(Item[] items) {
    }

    protected void doShowItem(Item item) {
    }

    protected void doShowSelection() {
    }

    protected ViewerRow internalCreateNewRowPart(int style, int rowIndex) {
        if (rowIndex >= this.rows.size()) {
            this.doSetItemCount(rowIndex + 1);
        }
        return this.rows.get(rowIndex);
    }

    protected ColumnViewerEditor createViewerEditor() {
        return null;
    }

    protected int doGetColumnCount() {
        return 5;
    }

    protected Item getItemAt(Point point) {
        Point displayPoint = this.control.toDisplay(point);
        int i = 0;
        while (i < this.rows.size()) {
            BoxItem item = (BoxItem)this.rows.get(i).getItem();
            Point p = item.getCanvas().toControl(displayPoint);
            Rectangle bounds = item.getBounds();
            if (p.x >= bounds.x && p.x < bounds.x + bounds.width && p.y >= bounds.y && p.y < bounds.y + bounds.height) {
                System.out.println("Item is " + (Object)((Object)item));
                return item;
            }
            ++i;
        }
        System.out.println("Item is null");
        return null;
    }

    protected ViewerRow getViewerRowFromItem(Widget item) {
        int i = 0;
        while (i < this.rows.size()) {
            if (this.rows.get(i).getItem() == item) {
                return this.rows.get(i);
            }
            ++i;
        }
        return null;
    }

    public Control getControl() {
        return this.control;
    }

    public void update(Object element, String[] properties) {
        super.update(element, properties);
        this.control.layout();
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        super.doUpdateItem(widget, element, fullMap);
        ((BoxItem)widget).getCanvas().layout();
    }

    public void refresh() {
        super.refresh();
        this.control.layout();
    }

    public void refresh(boolean updateLabels) {
        super.refresh(updateLabels);
        this.control.layout();
    }
}

