/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.views.IColumn;
import org.eclipsetrader.core.views.IWatchListColumn;
import org.eclipsetrader.core.views.WatchListColumn;
import org.eclipsetrader.ui.internal.views.ColumnsViewer;
import org.eclipsetrader.ui.internal.views.Messages;

public class ColumnsPage
extends WizardPage {
    private ColumnsViewer providers;
    private IColumn[] defaultColumns;

    public ColumnsPage() {
        super("columns", Messages.ColumnsPage_Columns, null);
        this.setDescription(Messages.ColumnsPage_SelectColumnsToDisplay);
    }

    public void setDefaultColumns(IColumn[] defaultColumns) {
        this.defaultColumns = defaultColumns;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)content);
        this.initializeDialogUnits((Control)content);
        CoreActivator activator = CoreActivator.getDefault();
        this.providers = new ColumnsViewer(content);
        this.providers.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.providers.setInput(activator.getDataProviderFactories());
        this.providers.setSelectedColumns(this.defaultColumns);
    }

    public boolean isPageComplete() {
        return true;
    }

    public IWatchListColumn[] getColumns() {
        ArrayList<Object> c = new ArrayList<Object>();
        IColumn[] iColumnArray = this.providers.getSelection();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            if (column instanceof IWatchListColumn) {
                c.add((IWatchListColumn)column);
            } else {
                c.add(new WatchListColumn(column));
            }
            ++n2;
        }
        return c.toArray(new IWatchListColumn[c.size()]);
    }
}

