/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.views.Messages;
import org.eclipsetrader.ui.internal.views.WatchListViewModel;

public class GeneralProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Text name;
    private ComboViewer repository;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GeneralProperties.this.setValid(GeneralProperties.this.isValid());
        }
    };

    public GeneralProperties() {
        this.setTitle(Messages.GeneralProperties_General);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        Label label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_WatchListName);
        this.name = new Text(content, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        label = new Label(content, 0);
        label.setText(Messages.GeneralProperties_TargetRepository);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label.setEnabled(false);
        this.repository = new ComboViewer(content, 8);
        this.repository.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.repository.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.repository.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repository.setSorter(new ViewerSorter());
        this.repository.setInput((Object)this.getRepositoryService().getRepositories());
        this.repository.getControl().setEnabled(false);
        this.performDefaults();
        this.name.addModifyListener(this.modifyListener);
        return content;
    }

    protected void performDefaults() {
        WatchListViewModel model = (WatchListViewModel)this.getElement().getAdapter(WatchListViewModel.class);
        this.name.setText(model.getName());
        IStoreObject storeObject = (IStoreObject)this.getElement().getAdapter(IStoreObject.class);
        this.repository.setSelection((ISelection)new StructuredSelection((Object)storeObject.getStore().getRepository()));
        super.performDefaults();
    }

    protected void applyChanges() {
        WatchListViewModel model = (WatchListViewModel)this.getElement().getAdapter(WatchListViewModel.class);
        model.setName(this.name.getText());
    }

    public boolean isValid() {
        if (this.name.getText().equals("")) {
            this.setErrorMessage(Messages.GeneralProperties_WatchListMustHaveName);
            return false;
        }
        IWatchList resource = this.getRepositoryService().getWatchListFromName(this.name.getText());
        if (resource != null && resource != this.getElement().getAdapter(IWatchList.class)) {
            this.setErrorMessage(Messages.GeneralProperties_SameNamePrompt);
            return false;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }

    protected void performApply() {
        this.applyChanges();
        super.performApply();
    }

    protected IRepositoryService getRepositoryService() {
        return UIActivator.getDefault().getRepositoryService();
    }
}

