/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.IBookEntry;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedConnector2;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.feed.IFeedSubscription2;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.ISubscriptionListener;
import org.eclipsetrader.core.feed.ITodayOHL;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.QuoteDelta;
import org.eclipsetrader.core.feed.QuoteEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.ITradingService;
import org.eclipsetrader.ui.SelectionProvider;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.views.Level2QuickTradeDecorator;
import org.eclipsetrader.ui.internal.views.Messages;
import org.eclipsetrader.ui.internal.views.PressureBar;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Level2View
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.views.level2";
    private static final String VIEW_TITLE_TOOLTIP = Messages.Level2View_LevelII;
    private IMarketService marketService;
    private IFeedService feedService;
    private Text symbol;
    private Label activeConnector;
    private Composite summaryGroup;
    private Label time;
    private Label volume;
    private Label last;
    private Label high;
    private Label change;
    private Label low;
    private PressureBar pressureBar;
    private Table table;
    private DateFormat timeFormatter = DateFormat.getTimeInstance(2);
    private NumberFormat numberFormatter = NumberFormat.getInstance();
    private NumberFormat priceFormatter = NumberFormat.getInstance();
    private NumberFormat percentageFormatter = NumberFormat.getInstance();
    private IMemento memento;
    private IFeedConnector2 connector;
    private IFeedSubscription2 subscription;
    private ITrade lastTrade;
    private ILastClose lastClose;
    private IBook lastBook;
    private IBook nextBook;
    private Action showMarketMakerAction;
    private Action hideSummaryAction;
    private ISubscriptionListener subscriptionListener = new ISubscriptionListener(){

        public void quoteUpdate(QuoteEvent event) {
            Level2View.this.onQuoteUpdate(event);
        }
    };
    private SelectionAdapter connectionSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget.getData() instanceof IFeedConnector2) {
                IFeedConnector2 newConnector = (IFeedConnector2)e.widget.getData();
                Level2View.this.onChangeConnector(newConnector);
            }
        }
    };
    private Runnable bookUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            if (Level2View.this.table == null || Level2View.this.table.isDisposed()) {
                return;
            }
            if (Level2View.this.lastBook != Level2View.this.nextBook) {
                IBook iBook = Level2View.this.nextBook;
                Level2View.this.lastBook = iBook;
                Level2View.this.onBookUpdate(iBook);
            }
            Display.getDefault().timerExec(100, Level2View.this.bookUpdateRunnable);
        }
    };

    public Level2View() {
        this.numberFormatter.setGroupingUsed(true);
        this.numberFormatter.setMinimumIntegerDigits(1);
        this.numberFormatter.setMinimumFractionDigits(0);
        this.numberFormatter.setMaximumFractionDigits(0);
        this.priceFormatter.setGroupingUsed(true);
        this.priceFormatter.setMinimumIntegerDigits(1);
        this.priceFormatter.setMinimumFractionDigits(2);
        this.priceFormatter.setMaximumFractionDigits(4);
        this.percentageFormatter.setGroupingUsed(true);
        this.percentageFormatter.setMinimumIntegerDigits(1);
        this.percentageFormatter.setMinimumFractionDigits(2);
        this.percentageFormatter.setMaximumFractionDigits(2);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
        BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
        ServiceReference marketServiceReference = context.getServiceReference(IMarketService.class);
        this.marketService = (IMarketService)context.getService(marketServiceReference);
        ServiceReference feedServiceReference = context.getServiceReference(IFeedService.class);
        this.feedService = (IFeedService)context.getService(feedServiceReference);
        this.showMarketMakerAction = new Action("Show Market Maker", 2){

            public void run() {
                Level2View.this.updateViewer();
                if (Level2View.this.lastBook != null) {
                    Level2View.this.onBookUpdate(Level2View.this.lastBook);
                }
            }
        };
        this.hideSummaryAction = new Action("Hide Summary", 2){

            public void run() {
                Level2View.this.summaryGroup.setVisible(!this.isChecked());
                ((GridData)((Level2View)Level2View.this).summaryGroup.getLayoutData()).exclude = this.isChecked();
                Level2View.this.summaryGroup.getParent().layout();
            }
        };
        if (memento != null) {
            this.hideSummaryAction.setChecked("true".equals(memento.getString("hide-summary")));
        }
        IActionBars actionBars = site.getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.showMarketMakerAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.hideSummaryAction);
        actionBars.updateActionBars();
        site.setSelectionProvider((ISelectionProvider)new SelectionProvider());
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        GC gc = new GC((Drawable)content);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Composite group = new Composite(content, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(group, 0);
        label.setText(Messages.Level2View_Symbol);
        this.symbol = new Text(group, 2048);
        this.symbol.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)15), -1));
        this.symbol.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Level2View.this.onSetSymbol();
            }
        });
        this.symbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Level2View.this.onSetSymbol();
            }
        });
        final ImageHyperlink connectorButton = new ImageHyperlink(group, 0);
        connectorButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        connectorButton.setImage(UIActivator.getDefault().getImageRegistry().get("toolbar-arrow-right.gif"));
        connectorButton.setToolTipText(Messages.Level2View_SelectDataSource);
        connectorButton.addHyperlinkListener(new IHyperlinkListener(){
            private Menu dropDownMenu;

            public void linkActivated(HyperlinkEvent e) {
                if (this.dropDownMenu != null) {
                    this.dropDownMenu.dispose();
                }
                this.dropDownMenu = new Menu((Control)connectorButton);
                List<IFeedConnector> c = Arrays.asList(Level2View.this.feedService.getConnectors());
                Collections.sort(c, new Comparator<IFeedConnector>(){

                    @Override
                    public int compare(IFeedConnector o1, IFeedConnector o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (IFeedConnector connector : c) {
                    if (!(connector instanceof IFeedConnector2)) continue;
                    MenuItem menuItem = new MenuItem(this.dropDownMenu, 32);
                    menuItem.setText(connector.getName());
                    menuItem.setData((Object)connector);
                    menuItem.setSelection(Level2View.this.connector == connector);
                    menuItem.addSelectionListener((SelectionListener)Level2View.this.connectionSelectionListener);
                }
                this.dropDownMenu.setVisible(true);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.activeConnector = new Label(group, 0);
        this.activeConnector.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.summaryGroup = this.createSummary(content);
        if (this.hideSummaryAction != null) {
            this.summaryGroup.setVisible(!this.hideSummaryAction.isChecked());
            ((GridData)this.summaryGroup.getLayoutData()).exclude = this.hideSummaryAction.isChecked();
        }
        this.pressureBar = new PressureBar(content, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = 16;
        this.pressureBar.getControl().setLayoutData((Object)gridData);
        this.createBookViewer(content);
        if (this.memento != null) {
            String id;
            String s = this.memento.getString("symbol");
            if (s != null) {
                this.symbol.setText(s);
                ISecurity security = this.getSecurityFromSymbol(s);
                if (security != null) {
                    this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)security));
                    this.setPartName(security.getName());
                    this.setTitleToolTip(NLS.bind((String)VIEW_TITLE_TOOLTIP, (Object[])new Object[]{security.getName()}));
                }
            }
            if ((id = this.memento.getString("connector")) != null) {
                IFeedConnector connector = this.feedService.getConnector(id);
                if (connector == null) {
                    connector = CoreActivator.getDefault().getDefaultConnector();
                }
                if (connector instanceof IFeedConnector2) {
                    this.connector = (IFeedConnector2)connector;
                    this.activeConnector.setText(this.connector.getName());
                }
            }
            if (s != null && this.connector != null) {
                this.subscription = this.connector.subscribeLevel2(s);
                this.subscription.addSubscriptionListener(this.subscriptionListener);
                this.lastClose = this.subscription.getLastClose();
                this.lastTrade = this.subscription.getTrade();
                this.update(this.subscription.getTodayOHL());
                this.update();
            }
        }
        Display.getDefault().timerExec(100, this.bookUpdateRunnable);
    }

    public void saveState(IMemento memento) {
        memento.putString("symbol", this.symbol.getText());
        if (this.connector != null) {
            memento.putString("connector", this.connector.getId());
        }
        if (this.hideSummaryAction.isChecked()) {
            memento.putString("hide-summary", "true");
        }
        super.saveState(memento);
    }

    public void setFocus() {
        this.symbol.setFocus();
    }

    public void dispose() {
        if (this.subscription != null) {
            this.subscription.removeSubscriptionListener(this.subscriptionListener);
            this.subscription.dispose();
        }
        BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
        ServiceReference marketServiceReference = context.getServiceReference(IMarketService.class);
        context.ungetService(marketServiceReference);
        ServiceReference feedServiceReference = context.getServiceReference(IFeedService.class);
        context.ungetService(feedServiceReference);
        super.dispose();
    }

    protected void createBookViewer(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout tableLayout = new TableColumnLayout();
        content.setLayout((Layout)tableLayout);
        this.table = new Table(content, 590338);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Level2View.this.table.deselectAll();
            }
        });
        ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        new Level2QuickTradeDecorator(this.table, commandService, handlerService);
        this.updateViewer();
    }

    protected void updateViewer() {
        TableColumn tableColumn;
        TableColumnLayout tableLayout = (TableColumnLayout)this.table.getParent().getLayout();
        int columnIndex = 0;
        if (this.showMarketMakerAction.isChecked()) {
            tableColumn = columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : new TableColumn(this.table, 0x1000000);
            tableColumn.setText(Messages.Level2View_MM);
            tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(5));
            ++columnIndex;
        }
        tableColumn = columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : new TableColumn(this.table, 0x1000000);
        tableColumn.setText(Messages.Level2View_Number);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(this.showMarketMakerAction.isChecked() ? 5 : 6));
        tableColumn = ++columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : new TableColumn(this.table, 0x1000000);
        tableColumn.setText(Messages.Level2View_Qty);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(this.showMarketMakerAction.isChecked() ? 22 : 24));
        tableColumn = ++columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : new TableColumn(this.table, 0x1000000);
        tableColumn.setText(Messages.Level2View_Bid);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(this.showMarketMakerAction.isChecked() ? 18 : 20));
        tableColumn = ++columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : new TableColumn(this.table, 0x1000000);
        tableColumn.setText(Messages.Level2View_Ask);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(this.showMarketMakerAction.isChecked() ? 18 : 20));
        tableColumn = ++columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : new TableColumn(this.table, 0x1000000);
        tableColumn.setText(Messages.Level2View_Qty);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(this.showMarketMakerAction.isChecked() ? 21 : 24));
        tableColumn = ++columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : new TableColumn(this.table, 0x1000000);
        tableColumn.setText(Messages.Level2View_Number);
        tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(this.showMarketMakerAction.isChecked() ? 5 : 6));
        ++columnIndex;
        if (this.showMarketMakerAction.isChecked()) {
            tableColumn = columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : new TableColumn(this.table, 0x1000000);
            tableColumn.setText(Messages.Level2View_MM);
            tableLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(5));
            ++columnIndex;
        }
        while (this.table.getColumnCount() > columnIndex) {
            this.table.getColumn(this.table.getColumnCount() - 1).dispose();
        }
        this.table.getParent().layout();
    }

    protected Composite createSummary(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing *= 2;
        content.setLayout((Layout)gridLayout);
        Label label = new Label(content, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        label = new Label(content, 0);
        label.setText(Messages.Level2View_Time);
        this.time = new Label(content, 131072);
        this.time.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setText(Messages.Level2View_Volume);
        this.volume = new Label(content, 131072);
        this.volume.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setText(Messages.Level2View_LastPrice);
        this.last = new Label(content, 131072);
        this.last.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setText(Messages.Level2View_High);
        this.high = new Label(content, 131072);
        this.high.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setText(Messages.Level2View_Change);
        this.change = new Label(content, 131072);
        this.change.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(content, 0);
        label.setText(Messages.Level2View_Low);
        this.low = new Label(content, 131072);
        this.low.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return content;
    }

    protected void updateBid(TableItem tableItem, IBookEntry entry) {
        int columnIndex = 0;
        if (entry != null) {
            String s;
            if (this.showMarketMakerAction.isChecked()) {
                String string = s = entry.getMarketMaker() != null ? entry.getMarketMaker() : "";
                if (!s.equals(tableItem.getText(columnIndex))) {
                    tableItem.setText(columnIndex, s);
                }
                ++columnIndex;
            }
            if (!(s = this.numberFormatter.format(entry.getProposals())).equals(tableItem.getText(columnIndex))) {
                tableItem.setText(columnIndex, s);
            }
            if (!(s = this.numberFormatter.format(entry.getQuantity())).equals(tableItem.getText(++columnIndex))) {
                tableItem.setText(columnIndex, s);
            }
            if (!(s = this.priceFormatter.format(entry.getPrice())).equals(tableItem.getText(++columnIndex))) {
                tableItem.setText(columnIndex, s);
            }
            ++columnIndex;
        } else {
            if (this.showMarketMakerAction.isChecked()) {
                tableItem.setText(columnIndex, "");
                tableItem.setBackground(columnIndex++, null);
            }
            tableItem.setText(columnIndex, "");
            tableItem.setBackground(columnIndex++, null);
            tableItem.setText(columnIndex, "");
            tableItem.setBackground(columnIndex++, null);
            tableItem.setText(columnIndex, "");
            tableItem.setBackground(columnIndex++, null);
        }
        tableItem.setData("bid", (Object)entry);
    }

    protected void updateAsk(TableItem tableItem, IBookEntry entry) {
        int columnIndex = tableItem.getParent().getColumnCount() - 1;
        if (entry != null) {
            String s;
            if (this.showMarketMakerAction.isChecked()) {
                String string = s = entry.getMarketMaker() != null ? entry.getMarketMaker() : "";
                if (!s.equals(tableItem.getText(columnIndex))) {
                    tableItem.setText(columnIndex, s);
                }
                --columnIndex;
            }
            if (!(s = this.numberFormatter.format(entry.getProposals())).equals(tableItem.getText(columnIndex))) {
                tableItem.setText(columnIndex, s);
            }
            if (!(s = this.numberFormatter.format(entry.getQuantity())).equals(tableItem.getText(--columnIndex))) {
                tableItem.setText(columnIndex, s);
            }
            if (!(s = this.priceFormatter.format(entry.getPrice())).equals(tableItem.getText(--columnIndex))) {
                tableItem.setText(columnIndex, s);
            }
            --columnIndex;
        } else {
            if (this.showMarketMakerAction.isChecked()) {
                tableItem.setText(columnIndex, "");
                tableItem.setBackground(columnIndex--, null);
            }
            tableItem.setText(columnIndex, "");
            tableItem.setBackground(columnIndex--, null);
            tableItem.setText(columnIndex, "");
            tableItem.setBackground(columnIndex--, null);
            tableItem.setText(columnIndex, "");
            tableItem.setBackground(columnIndex--, null);
        }
        tableItem.setData("ask", (Object)entry);
    }

    protected void onBookUpdate(IBook book) {
        IBookEntry[] bidEntries = book.getBidProposals();
        IBookEntry[] askEntries = book.getAskProposals();
        int rows = Math.max(bidEntries.length, askEntries.length);
        this.table.setRedraw(false);
        boolean doLayout = rows != this.table.getItemCount();
        try {
            int rowIndex = 0;
            while (rowIndex < rows) {
                TableItem tableItem = rowIndex < this.table.getItemCount() ? this.table.getItem(rowIndex) : new TableItem(this.table, 0);
                this.updateBid(tableItem, rowIndex < bidEntries.length ? bidEntries[rowIndex] : null);
                this.updateAsk(tableItem, rowIndex < askEntries.length ? askEntries[rowIndex] : null);
                ++rowIndex;
            }
            while (this.table.getItemCount() > rows) {
                this.table.getItem(this.table.getItemCount() - 1).dispose();
            }
        }
        finally {
            this.table.setRedraw(true);
        }
        if (doLayout) {
            this.table.layout();
            this.table.getParent().layout();
            this.table.layout();
            this.table.getParent().layout();
        }
        long[] leftWeights = new long[Math.min(bidEntries.length, 5)];
        int i = 0;
        while (i < leftWeights.length) {
            leftWeights[i] = bidEntries[i] != null && bidEntries[i].getQuantity() != null ? bidEntries[i].getQuantity() : 0L;
            ++i;
        }
        long[] rightWeights = new long[Math.min(askEntries.length, 5)];
        int i2 = 0;
        while (i2 < rightWeights.length) {
            rightWeights[i2] = askEntries[i2] != null && askEntries[i2].getQuantity() != null ? askEntries[i2].getQuantity() : 0L;
            ++i2;
        }
        this.pressureBar.setWeights(leftWeights, rightWeights);
    }

    protected void onSetSymbol() {
        if (this.subscription != null && this.subscription.getSymbol().equals(this.symbol.getText())) {
            return;
        }
        if (this.connector != null) {
            ISecurity security;
            if (this.subscription != null) {
                this.subscription.removeSubscriptionListener(this.subscriptionListener);
                this.subscription.dispose();
            }
            this.subscription = this.connector.subscribeLevel2(this.symbol.getText());
            this.subscription.addSubscriptionListener(this.subscriptionListener);
            this.lastClose = this.subscription.getLastClose();
            this.lastTrade = this.subscription.getTrade();
            this.update(this.subscription.getTodayOHL());
            this.update();
            IBook book = this.subscription.getBook();
            if (book != null) {
                this.onBookUpdate(book);
            }
            if ((security = this.getSecurityFromSymbol(this.symbol.getText())) != null) {
                this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)security));
                this.setPartName(security.getName());
                this.setTitleToolTip(NLS.bind((String)VIEW_TITLE_TOOLTIP, (Object[])new Object[]{security.getName()}));
            }
        }
    }

    protected void onChangeConnector(IFeedConnector2 newConnector) {
        if (newConnector != this.connector) {
            if (this.connector != null && this.subscription != null) {
                this.subscription.removeSubscriptionListener(this.subscriptionListener);
                this.subscription.dispose();
                this.subscription = null;
            }
            this.connector = newConnector;
            this.activeConnector.setText(this.connector != null ? this.connector.getName() : "");
            if (this.connector != null && !this.symbol.getText().equals("")) {
                this.subscription = this.connector.subscribeLevel2(this.symbol.getText());
                this.subscription.addSubscriptionListener(this.subscriptionListener);
                this.lastClose = this.subscription.getLastClose();
                this.lastTrade = this.subscription.getTrade();
                this.update(this.subscription.getTodayOHL());
                this.update();
                IBook book = this.subscription.getBook();
                if (book != null) {
                    this.onBookUpdate(book);
                }
            }
        }
    }

    public void setSecurity(ISecurity security) {
        IFeedConnector connector = null;
        IMarket[] market = this.marketService.getMarkets();
        int i = 0;
        while (i < market.length) {
            if (market[i].hasMember(security)) {
                connector = market[i].getLiveFeedConnector();
                break;
            }
            ++i;
        }
        if (connector == null) {
            connector = CoreActivator.getDefault().getDefaultConnector();
        }
        if (connector instanceof IFeedConnector2) {
            this.connector = (IFeedConnector2)connector;
        }
        if (this.connector != null) {
            IFeedIdentifier feedIdentifier;
            this.activeConnector.setText(this.connector.getName());
            if (this.subscription != null) {
                this.subscription.removeSubscriptionListener(this.subscriptionListener);
                this.subscription.dispose();
            }
            if ((feedIdentifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class)) != null) {
                this.subscription = this.connector.subscribeLevel2(feedIdentifier);
                this.subscription.addSubscriptionListener(this.subscriptionListener);
                this.symbol.setText(this.subscription.getSymbol());
                this.lastClose = this.subscription.getLastClose();
                this.lastTrade = this.subscription.getTrade();
                this.update(this.subscription.getTodayOHL());
                this.update();
                IBook book = this.subscription.getBook();
                if (book != null) {
                    this.onBookUpdate(book);
                }
            }
        }
        this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)security));
    }

    protected void onQuoteUpdate(final QuoteEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Level2View.this.table.isDisposed()) {
                    return;
                }
                QuoteDelta[] delta = event.getDelta();
                int i = 0;
                while (i < delta.length) {
                    if (delta[i].getNewValue() instanceof IBook) {
                        Level2View.this.nextBook = (IBook)delta[i].getNewValue();
                    }
                    if (delta[i].getNewValue() instanceof ITrade) {
                        Level2View.this.lastTrade = (ITrade)delta[i].getNewValue();
                        Level2View.this.update();
                    }
                    if (delta[i].getNewValue() instanceof ITodayOHL) {
                        ITodayOHL todayOHL = (ITodayOHL)delta[i].getNewValue();
                        Level2View.this.update(todayOHL);
                    }
                    if (delta[i].getNewValue() instanceof ILastClose) {
                        Level2View.this.lastClose = (ILastClose)delta[i].getNewValue();
                        Level2View.this.update();
                    }
                    ++i;
                }
            }
        });
    }

    protected void update() {
        this.time.setText(this.lastTrade != null && this.lastTrade.getTime() != null ? this.timeFormatter.format(this.lastTrade.getTime()) : "");
        this.last.setText(this.lastTrade != null && this.lastTrade.getPrice() != null ? this.priceFormatter.format(this.lastTrade.getPrice()) : "");
        this.volume.setText(this.lastTrade != null && this.lastTrade.getVolume() != null ? this.numberFormatter.format(this.lastTrade.getVolume()) : "");
        if (this.lastTrade != null && this.lastClose != null && this.lastClose.getPrice() != null && this.lastTrade.getPrice() != null) {
            double changePercent = (this.lastTrade.getPrice() - this.lastClose.getPrice()) / this.lastClose.getPrice() * 100.0;
            this.change.setText(NLS.bind((String)"{0}{1}%", (Object[])new Object[]{changePercent < 0.0 ? "-" : (changePercent > 0.0 ? "+" : ""), this.percentageFormatter.format(Math.abs(changePercent))}));
        } else {
            this.change.setText("");
        }
    }

    protected void update(ITodayOHL todayOHL) {
        this.high.setText(todayOHL != null && todayOHL.getHigh() != null ? this.priceFormatter.format(todayOHL.getHigh()) : "");
        this.low.setText(todayOHL != null && todayOHL.getLow() != null ? this.priceFormatter.format(todayOHL.getLow()) : "");
    }

    protected ISecurity getSecurityFromSymbol(String symbol) {
        ISecurity security = null;
        BundleContext context = UIActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(ITradingService.class.getName());
        if (serviceReference != null) {
            ITradingService service = (ITradingService)context.getService(serviceReference);
            IBroker[] broker = service.getBrokers();
            int i = 0;
            while (i < broker.length) {
                security = broker[i].getSecurityFromSymbol(symbol);
                if (security != null) break;
                ++i;
            }
            context.ungetService(serviceReference);
        }
        return security;
    }
}

