/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PressureBar {
    private Canvas canvas;
    private long[] leftWeights;
    private long[] rightWeights;
    private Color separatorColor;
    private Color[] bandColors;
    private int separatorWidth = 3;

    PressureBar() {
    }

    public PressureBar(Composite parent, int style) {
        this.canvas = new Canvas(parent, style | 0x20000000);
        this.canvas.setBackground(parent.getDisplay().getSystemColor(18));
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                try {
                    PressureBar.this.onPaintControl(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        });
        this.separatorColor = Display.getCurrent().getSystemColor(2);
        this.bandColors = new Color[]{Display.getCurrent().getSystemColor(7), Display.getCurrent().getSystemColor(5), Display.getCurrent().getSystemColor(13), Display.getCurrent().getSystemColor(4), Display.getCurrent().getSystemColor(9)};
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color indicatorColor) {
        this.separatorColor = indicatorColor;
        this.canvas.redraw();
    }

    public Color[] getBandColors() {
        return this.bandColors;
    }

    public void setBandColors(Color[] bandColors) {
        this.bandColors = bandColors;
        this.canvas.redraw();
    }

    public void setWeights(long[] leftWeights, long[] rightWeights) {
        this.leftWeights = leftWeights;
        this.rightWeights = rightWeights;
        this.canvas.redraw();
    }

    protected void onPaintControl(PaintEvent e) {
        Rectangle clientArea = ((Control)e.widget).getBounds();
        if (this.leftWeights != null && this.rightWeights != null) {
            int x = 0;
            int index = 0;
            int[] widths = this.getBandWidths(this.leftWeights, this.rightWeights, clientArea);
            int i = this.leftWeights.length - 1;
            while (i >= 0) {
                e.gc.setBackground(this.bandColors[i]);
                e.gc.fillRectangle(x, 0, widths[i + index], clientArea.height);
                x += widths[i + index];
                --i;
            }
            e.gc.setBackground(this.separatorColor);
            e.gc.fillRectangle(x, 0, widths[index += this.leftWeights.length], clientArea.height);
            x += widths[index++];
            i = 0;
            while (i < this.rightWeights.length && i < 5) {
                e.gc.setBackground(this.bandColors[i]);
                e.gc.fillRectangle(x, 0, widths[i + index], clientArea.height);
                x += widths[i + index];
                ++i;
            }
        }
    }

    protected int[] getBandWidths(long[] leftWeights, long[] rightWeights, Rectangle clientArea) {
        int maxWidth;
        double total = 0.0;
        int i = 0;
        while (i < leftWeights.length) {
            total += (double)leftWeights[i];
            ++i;
        }
        i = 0;
        while (i < rightWeights.length) {
            total += (double)rightWeights[i];
            ++i;
        }
        int bands = leftWeights.length + 1 + rightWeights.length;
        int[] widths = new int[bands];
        int last = maxWidth = clientArea.width - this.separatorWidth;
        int index = 0;
        int i2 = 0;
        while (i2 < leftWeights.length) {
            widths[index] = (int)((double)maxWidth / total * (double)leftWeights[i2]);
            last -= widths[index];
            ++i2;
            ++index;
        }
        widths[index++] = this.separatorWidth;
        i2 = 0;
        while (i2 < rightWeights.length - 1) {
            widths[index] = (int)((double)maxWidth / total * (double)rightWeights[i2]);
            last -= widths[index];
            ++i2;
            ++index;
        }
        if (index < widths.length) {
            widths[index] = last;
        }
        return widths;
    }

    public Control getControl() {
        return this.canvas;
    }

    public int getSeparatorWidth() {
        return this.separatorWidth;
    }

    public void setSeparatorWidth(int separatorWidth) {
        this.separatorWidth = separatorWidth;
        this.canvas.redraw();
    }
}

