/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.views.Messages;
import org.eclipsetrader.ui.internal.views.SecuritySelectionControl;
import org.eclipsetrader.ui.internal.views.TickerViewItem;
import org.eclipsetrader.ui.internal.views.TickersView;

public class SecurityProperties
extends PropertyPage
implements IWorkbenchPropertyPage {
    private SecuritySelectionControl providers;

    public SecurityProperties() {
        this.setTitle(Messages.SecurityProperties_Securities);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)content);
        this.providers = new SecuritySelectionControl(content);
        this.providers.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.providers.setInput(UIActivator.getDefault().getRepositoryService().getSecurities());
        this.performDefaults();
        return content;
    }

    protected void performDefaults() {
        TickersView resource = (TickersView)((Object)this.getElement().getAdapter(TickersView.class));
        TickerViewItem[] columns = resource.getViewItems();
        ISecurity[] selectedColumns = new ISecurity[columns.length];
        int i = 0;
        while (i < selectedColumns.length) {
            selectedColumns[i] = columns[i].getSecurity();
            ++i;
        }
        this.providers.setSelectedColumns(selectedColumns);
        super.performDefaults();
    }

    protected void applyChanges() {
        TickersView resource = (TickersView)((Object)this.getElement().getAdapter(TickersView.class));
        if (resource != null) {
            ArrayList<TickerViewItem> c = new ArrayList<TickerViewItem>();
            ISecurity[] iSecurityArray = this.providers.getSelection();
            int n = iSecurityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISecurity column = iSecurityArray[n2];
                c.add(new TickerViewItem(column));
                ++n2;
            }
            resource.setViewItems(c.toArray(new TickerViewItem[c.size()]));
        }
    }

    protected void performApply() {
        this.applyChanges();
        super.performApply();
    }

    public boolean performOk() {
        if (this.getControl() != null) {
            this.applyChanges();
        }
        return super.performOk();
    }
}

