/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.views.Messages;

public class SecuritySelectionControl {
    private Composite control;
    private TableViewer available;
    private Button right;
    private Button allRight;
    private Button allLeft;
    private Button left;
    private TableViewer selected;
    private Button up;
    private Button down;
    private Image rightImage = UIActivator.getImageDescriptor("icons/etool16/right.gif").createImage();
    private Image allRightImage = UIActivator.getImageDescriptor("icons/etool16/all-right.gif").createImage();
    private Image allLeftImage = UIActivator.getImageDescriptor("icons/etool16/all-left.gif").createImage();
    private Image leftImage = UIActivator.getImageDescriptor("icons/etool16/left.gif").createImage();
    private Image upImage = UIActivator.getImageDescriptor("icons/etool16/up.gif").createImage();
    private Image downImage = UIActivator.getImageDescriptor("icons/etool16/down.gif").createImage();
    private List<ISecurity> input = new ArrayList<ISecurity>();
    private List<ISecurity> selection = new ArrayList<ISecurity>();
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            if (SecuritySelectionControl.this.rightImage != null) {
                SecuritySelectionControl.this.rightImage.dispose();
            }
            if (SecuritySelectionControl.this.allRightImage != null) {
                SecuritySelectionControl.this.allRightImage.dispose();
            }
            if (SecuritySelectionControl.this.allLeftImage != null) {
                SecuritySelectionControl.this.allLeftImage.dispose();
            }
            if (SecuritySelectionControl.this.leftImage != null) {
                SecuritySelectionControl.this.leftImage.dispose();
            }
            if (SecuritySelectionControl.this.upImage != null) {
                SecuritySelectionControl.this.upImage.dispose();
            }
            if (SecuritySelectionControl.this.downImage != null) {
                SecuritySelectionControl.this.downImage.dispose();
            }
        }
    };

    public SecuritySelectionControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.control.setLayout((Layout)gridLayout);
        this.createLabels(this.control);
        this.createInputViewer(this.control);
        this.createSelectionViewer(this.control);
        this.control.addDisposeListener(this.disposeListener);
        this.updateControlsEnablement();
    }

    public Composite getControl() {
        return this.control;
    }

    protected void createLabels(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.SecuritySelectionControl_AvailableInstruments);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label(parent, 0);
        label.setText(Messages.SecuritySelectionControl_SelectedInstruments);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    protected void createInputViewer(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        control.setLayout((Layout)gridLayout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.available = new TableViewer(control, 67586);
        this.available.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.available.getControl().getLayoutData()).heightHint = this.available.getTable().getItemHeight() * 15 + this.available.getTable().getBorderWidth() * 2;
        this.available.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ISecurity)element).getName();
            }
        });
        this.available.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.available.setSorter(new ViewerSorter());
        this.available.setInput(this.input);
        this.available.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SecuritySelectionControl.this.updateControlsEnablement();
            }
        });
        this.createInputButtons(control);
    }

    protected void createInputButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.right = new Button(buttons, 8);
        this.right.setImage(this.rightImage);
        this.right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SecuritySelectionControl.this.available.getSelection() instanceof IStructuredSelection && !SecuritySelectionControl.this.available.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)SecuritySelectionControl.this.available.getSelection()).toArray();
                    int i = 0;
                    while (i < s.length) {
                        SecuritySelectionControl.this.selection.add((ISecurity)s[i]);
                        SecuritySelectionControl.this.input.remove(s[i]);
                        ++i;
                    }
                    SecuritySelectionControl.this.available.refresh();
                    SecuritySelectionControl.this.selected.refresh();
                    SecuritySelectionControl.this.updateControlsEnablement();
                }
            }
        });
        this.allRight = new Button(buttons, 8);
        this.allRight.setImage(this.allRightImage);
        this.allRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecuritySelectionControl.this.selection.clear();
                for (ISecurity factory : SecuritySelectionControl.this.input) {
                    SecuritySelectionControl.this.selection.add(factory);
                }
                SecuritySelectionControl.this.input.clear();
                SecuritySelectionControl.this.available.refresh();
                SecuritySelectionControl.this.selected.refresh();
                SecuritySelectionControl.this.updateControlsEnablement();
            }
        });
        this.allLeft = new Button(buttons, 8);
        this.allLeft.setImage(this.allLeftImage);
        this.allLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecuritySelectionControl.this.selected.remove(SecuritySelectionControl.this.selection.toArray());
                SecuritySelectionControl.this.selection.clear();
                SecuritySelectionControl.this.updateControlsEnablement();
            }
        });
        this.left = new Button(buttons, 8);
        this.left.setImage(this.leftImage);
        this.left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SecuritySelectionControl.this.selected.getSelection() instanceof IStructuredSelection && !SecuritySelectionControl.this.selected.getSelection().isEmpty()) {
                    List s = ((IStructuredSelection)SecuritySelectionControl.this.selected.getSelection()).toList();
                    SecuritySelectionControl.this.selected.remove(s.toArray());
                    SecuritySelectionControl.this.selection.removeAll(s);
                    SecuritySelectionControl.this.updateControlsEnablement();
                }
            }
        });
    }

    protected void createSelectionViewer(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        control.setLayout((Layout)gridLayout);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selected = new TableViewer(control, 67586);
        this.selected.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.selected.getControl().getLayoutData()).heightHint = this.selected.getTable().getItemHeight() * 15 + this.selected.getTable().getBorderWidth() * 2;
        this.selected.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ISecurity)element).getName();
            }
        });
        this.selected.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selected.setInput(this.selection);
        this.selected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SecuritySelectionControl.this.updateControlsEnablement();
            }
        });
        this.createSelectionButtons(control);
    }

    protected void moveSelectionUp(Object[] s) {
        ArrayList<ISecurity> l = new ArrayList<ISecurity>();
        int index = 999999;
        int i = 0;
        while (i < s.length) {
            index = Math.min(index, this.selection.indexOf(s[i]));
            l.add((ISecurity)s[i]);
            ++i;
        }
        if (index > 0) {
            this.selection.removeAll(l);
            this.selection.addAll(--index, l);
            this.selected.refresh();
        }
    }

    protected void moveSelectionDown(Object[] s) {
        ArrayList<ISecurity> l = new ArrayList<ISecurity>();
        int index = -1;
        int i = 0;
        while (i < s.length) {
            index = Math.max(index, this.selection.indexOf(s[i]));
            l.add((ISecurity)s[i]);
            ++i;
        }
        if (index < this.selection.size() - 1) {
            ++index;
            this.selection.removeAll(l);
            this.selection.addAll(index -= l.size() - 1, l);
            this.selected.refresh();
        }
    }

    protected void createSelectionButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.up = new Button(buttons, 8);
        this.up.setImage(this.upImage);
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SecuritySelectionControl.this.selected.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)SecuritySelectionControl.this.selected.getSelection()).toArray();
                    SecuritySelectionControl.this.moveSelectionUp(s);
                    SecuritySelectionControl.this.updateControlsEnablement();
                }
            }
        });
        this.down = new Button(buttons, 8);
        this.down.setImage(this.downImage);
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SecuritySelectionControl.this.selected.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)SecuritySelectionControl.this.selected.getSelection()).toArray();
                    SecuritySelectionControl.this.moveSelectionDown(s);
                    SecuritySelectionControl.this.updateControlsEnablement();
                }
            }
        });
    }

    public void setInput(ISecurity[] factories) {
        this.input.clear();
        this.input.addAll(Arrays.asList(factories));
        this.available.refresh();
        this.updateControlsEnablement();
    }

    public void setSelectedColumns(ISecurity[] columns) {
        this.selection.clear();
        int i = 0;
        while (i < columns.length) {
            this.selection.add(columns[i]);
            ++i;
        }
        this.selected.refresh();
        this.input.removeAll(Arrays.asList(columns));
        this.available.refresh();
        this.updateControlsEnablement();
    }

    public ISecurity[] getSelection() {
        return this.selection.toArray(new ISecurity[this.selection.size()]);
    }

    protected void updateControlsEnablement() {
        this.right.setEnabled(!this.available.getSelection().isEmpty());
        this.allRight.setEnabled(this.input.size() != 0);
        this.left.setEnabled(!this.selected.getSelection().isEmpty());
        this.allLeft.setEnabled(this.selection.size() != 0);
        int upperIndex = -1;
        int lowerIndex = 999999;
        Object[] s = ((IStructuredSelection)this.selected.getSelection()).toArray();
        int i = 0;
        while (i < s.length) {
            upperIndex = Math.max(upperIndex, this.selection.indexOf(s[i]));
            lowerIndex = Math.min(lowerIndex, this.selection.indexOf(s[i]));
            ++i;
        }
        this.up.setEnabled(!this.selected.getSelection().isEmpty() && upperIndex > 0);
        this.down.setEnabled(!this.selected.getSelection().isEmpty() && lowerIndex < this.selection.size() - 1);
    }
}

