/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.ui.internal.views;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.views.IDataProvider;
import org.eclipsetrader.ui.internal.UIActivator;
import org.eclipsetrader.ui.internal.providers.ChangeFactory;
import org.eclipsetrader.ui.internal.providers.LastTradePriceFactory;
import org.eclipsetrader.ui.internal.providers.LastTradeTimeFactory;
import org.eclipsetrader.ui.internal.providers.SecurityNameFactory;
import org.eclipsetrader.ui.internal.providers.TrendFactory;
import org.eclipsetrader.ui.internal.views.BoxViewer;
import org.eclipsetrader.ui.internal.views.Messages;
import org.eclipsetrader.ui.internal.views.TickerViewItem;
import org.eclipsetrader.ui.internal.views.TickersSettingsAction;
import org.eclipsetrader.ui.internal.views.ViewItemLabelProvider;
import org.eclipsetrader.ui.navigator.RepositoryObjectTransfer;
import org.eclipsetrader.ui.navigator.SecurityObjectTransfer;

public class TickersView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipsetrader.ui.views.tickers";
    public static final String K_SECURITIES = "securities";
    private BoxViewer viewer;
    private IDialogSettings dialogSettings;
    private Action deleteAction;
    private Action settingsAction;
    private List<TickerViewItem> input;
    private MarketPricingEnvironment pricingEnvironment;
    private IDataProvider[] providers;
    private IPricingListener pricingListener = new IPricingListener(){

        public void pricingUpdate(PricingEvent event) {
            TickersView.this.onPricingUpdate(event);
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        ImageRegistry imageRegistry = UIActivator.getDefault().getImageRegistry();
        this.dialogSettings = UIActivator.getDefault().getDialogSettings().getSection(site.getId());
        if (this.dialogSettings == null) {
            this.dialogSettings = UIActivator.getDefault().getDialogSettings().addNewSection(site.getId());
        }
        this.deleteAction = new Action(Messages.TickersView_Delete){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)TickersView.this.viewer.getSelection();
                TickersView.this.input.removeAll(selection.toList());
                Object[] o = selection.toArray();
                ISecurity[] s = new ISecurity[o.length];
                int i = 0;
                while (i < s.length) {
                    s[i] = ((TickerViewItem)o[i]).getSecurity();
                    ++i;
                }
                TickersView.this.pricingEnvironment.removeSecurities(s);
                TickersView.this.saveInput();
                TickersView.this.viewer.refresh();
            }
        };
        this.deleteAction.setImageDescriptor(imageRegistry.getDescriptor("delete_edit"));
        this.deleteAction.setDisabledImageDescriptor(imageRegistry.getDescriptor("delete_edit_disabled"));
        this.deleteAction.setId(ActionFactory.DELETE.getId());
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setEnabled(false);
        this.settingsAction = new TickersSettingsAction(site.getShell(), this);
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(this.settingsAction.getId(), (IAction)this.settingsAction);
        actionBars.setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        actionBars.updateActionBars();
    }

    public void createPartControl(Composite parent) {
        this.viewer = this.createViewer(parent);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TickersView.this.deleteAction.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.viewer.addDropSupport(3, new Transfer[]{SecurityObjectTransfer.getInstance(), RepositoryObjectTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return SecurityObjectTransfer.getInstance().isSupportedType(transferType) || RepositoryObjectTransfer.getInstance().isSupportedType(transferType);
            }

            public boolean performDrop(Object data) {
                IAdaptable[] contents = (IAdaptable[])data;
                int i = 0;
                while (i < contents.length) {
                    ISecurity security = (ISecurity)contents[i].getAdapter(ISecurity.class);
                    if (security != null) {
                        TickerViewItem viewItem = new TickerViewItem(security);
                        TickersView.this.input.add(viewItem);
                        TickersView.this.pricingEnvironment.addSecurity(security);
                        viewItem.setTrade(TickersView.this.pricingEnvironment.getTrade(security));
                        viewItem.setQuote(TickersView.this.pricingEnvironment.getQuote(security));
                        viewItem.setLastClose(TickersView.this.pricingEnvironment.getLastClose(security));
                        IAdaptable[] newValues = new IAdaptable[TickersView.this.providers.length];
                        int ii = 0;
                        while (ii < newValues.length) {
                            newValues[ii] = TickersView.this.providers[ii] != null ? TickersView.this.providers[ii].getValue((IAdaptable)viewItem) : null;
                            ++ii;
                        }
                        viewItem.setValues(newValues);
                    }
                    ++i;
                }
                TickersView.this.viewer.refresh();
                TickersView.this.saveInput();
                return true;
            }
        });
        this.providers = new IDataProvider[]{new SecurityNameFactory().createProvider(), new LastTradeTimeFactory().createProvider(), new LastTradePriceFactory().createProvider(), new ChangeFactory().createProvider(), new TrendFactory().createProvider()};
        IRepositoryService repository = this.getRepositoryService();
        this.input = new ArrayList<TickerViewItem>();
        ArrayList<ISecurity> l = new ArrayList<ISecurity>();
        String[] uri = this.dialogSettings.getArray(K_SECURITIES);
        if (uri != null) {
            int i = 0;
            while (i < uri.length) {
                try {
                    ISecurity security = repository.getSecurityFromURI(new URI(uri[i]));
                    l.add(security);
                    this.input.add(new TickerViewItem(security));
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipsetrader.ui", "Error loading security " + uri[i], (Throwable)e);
                    UIActivator.getDefault().getLog().log((IStatus)status);
                }
                ++i;
            }
        }
        this.pricingEnvironment = new MarketPricingEnvironment(this.getMarketService(), l.toArray(new ISecurity[l.size()]));
        this.pricingEnvironment.addPricingListener(this.pricingListener);
        for (TickerViewItem viewItem : this.input) {
            viewItem.setTrade(this.pricingEnvironment.getTrade(viewItem.getSecurity()));
            viewItem.setQuote(this.pricingEnvironment.getQuote(viewItem.getSecurity()));
            viewItem.setLastClose(this.pricingEnvironment.getLastClose(viewItem.getSecurity()));
            IAdaptable[] newValues = new IAdaptable[this.providers.length];
            int ii = 0;
            while (ii < newValues.length) {
                newValues[ii] = this.providers[ii] != null ? this.providers[ii].getValue((IAdaptable)viewItem) : null;
                ++ii;
            }
            viewItem.setValues(newValues);
        }
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IAction)TickersView.this.deleteAction);
                menuManager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput(this.input);
    }

    public void setFocus() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        if (this.pricingEnvironment != null) {
            this.pricingEnvironment.removePricingListener(this.pricingListener);
            this.pricingEnvironment.dispose();
        }
        this.saveInput();
        super.dispose();
    }

    protected void saveInput() {
        String[] ar = new String[this.input.size()];
        int i = 0;
        while (i < ar.length) {
            IStoreObject storeObject = (IStoreObject)this.input.get(i).getSecurity().getAdapter(IStoreObject.class);
            ar[i] = storeObject.getStore().toURI().toString();
            ++i;
        }
        this.dialogSettings.put(K_SECURITIES, ar);
    }

    protected BoxViewer createViewer(Composite parent) {
        BoxViewer viewer = new BoxViewer(parent);
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new ViewItemLabelProvider());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return viewer;
    }

    protected int compareValues(IAdaptable[] v1, IAdaptable[] v2, int sortColumn) {
        if (sortColumn < 0 || sortColumn >= v1.length || sortColumn >= v2.length) {
            return 0;
        }
        if (v1[sortColumn] == null || v2[sortColumn] == null) {
            return 0;
        }
        Object o1 = v1[sortColumn].getAdapter(Comparable.class);
        Object o2 = v2[sortColumn].getAdapter(Comparable.class);
        if (o1 != null && o2 != null) {
            return ((Comparable)o1).compareTo(o2);
        }
        o1 = v1[sortColumn].getAdapter(Number.class);
        o2 = v2[sortColumn].getAdapter(Number.class);
        if (o1 != null && o2 != null) {
            if (((Number)o1).doubleValue() < ((Number)o2).doubleValue()) {
                return -1;
            }
            if (((Number)o1).doubleValue() > ((Number)o2).doubleValue()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPricingUpdate(PricingEvent event) {
        final ArrayList<TickerViewItem> l = new ArrayList<TickerViewItem>();
        List<TickerViewItem> list = this.input;
        synchronized (list) {
            for (TickerViewItem viewItem : this.input) {
                if (viewItem.getSecurity() != event.getSecurity()) continue;
                PricingDelta[] pricingDeltaArray = event.getDelta();
                int n = pricingDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PricingDelta delta = pricingDeltaArray[n2];
                    if (delta.getNewValue() instanceof ITrade) {
                        viewItem.setTrade((ITrade)delta.getNewValue());
                    }
                    if (delta.getNewValue() instanceof IQuote) {
                        viewItem.setQuote((IQuote)delta.getNewValue());
                    }
                    if (delta.getNewValue() instanceof ILastClose) {
                        viewItem.setLastClose((ILastClose)delta.getNewValue());
                    }
                    ++n2;
                }
                IAdaptable[] oldValues = viewItem.getValues();
                IAdaptable[] newValues = new IAdaptable[this.providers.length];
                int i = 0;
                while (i < newValues.length) {
                    newValues[i] = this.providers[i] != null ? this.providers[i].getValue((IAdaptable)viewItem) : null;
                    ++i;
                }
                if (this.valuesEquals(oldValues, newValues)) continue;
                viewItem.setValues(newValues);
                l.add(viewItem);
            }
        }
        if (!this.viewer.getControl().isDisposed()) {
            try {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!TickersView.this.viewer.getControl().isDisposed()) {
                            TickersView.this.viewer.update(l.toArray(), null);
                        }
                    }
                });
            }
            catch (SWTException sWTException) {}
        }
    }

    protected boolean valuesEquals(IAdaptable[] oldValues, IAdaptable[] newValues) {
        if (oldValues == newValues) {
            return true;
        }
        if (oldValues == null && newValues != null || oldValues != null && newValues == null) {
            return false;
        }
        if (oldValues.length != newValues.length) {
            return false;
        }
        int i = 0;
        while (i < newValues.length) {
            if (oldValues[i] != newValues[i]) {
                if (oldValues[i] == null && newValues[i] != null || oldValues[i] != null && newValues[i] == null) {
                    return false;
                }
                if (!newValues[i].equals(oldValues[i])) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected IRepositoryService getRepositoryService() {
        return UIActivator.getDefault().getRepositoryService();
    }

    protected IMarketService getMarketService() {
        return UIActivator.getDefault().getMarketService();
    }

    public TickerViewItem[] getViewItems() {
        return this.input.toArray(new TickerViewItem[this.input.size()]);
    }

    public void setViewItems(TickerViewItem[] input) {
        TickerViewItem viewItem;
        TickerViewItem[] tickerViewItemArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            viewItem = tickerViewItemArray[n2];
            this.pricingEnvironment.removeSecurity(viewItem.getSecurity());
            ++n2;
        }
        this.input = new ArrayList<TickerViewItem>(Arrays.asList(input));
        this.saveInput();
        tickerViewItemArray = input;
        n = input.length;
        n2 = 0;
        while (n2 < n) {
            viewItem = tickerViewItemArray[n2];
            this.pricingEnvironment.addSecurity(viewItem.getSecurity());
            viewItem.setTrade(this.pricingEnvironment.getTrade(viewItem.getSecurity()));
            viewItem.setQuote(this.pricingEnvironment.getQuote(viewItem.getSecurity()));
            viewItem.setLastClose(this.pricingEnvironment.getLastClose(viewItem.getSecurity()));
            IAdaptable[] newValues = new IAdaptable[this.providers.length];
            int ii = 0;
            while (ii < newValues.length) {
                newValues[ii] = this.providers[ii] != null ? this.providers[ii].getValue((IAdaptable)viewItem) : null;
                ++ii;
            }
            viewItem.setValues(newValues);
            ++n2;
        }
        this.viewer.setInput(this.input);
    }
}

